/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Fri May  9 09:16:06 IDT 2003
    copyright            : (C) 2003 by Elad Lahav
    email                : elad_lahav@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>

#include "kscope.h"
#include "kscopeconfig.h"

static const char *description =
	I18N_NOOP("KScope\nA source-editing environment for KDE, based on "
	"Cscope");

static KCmdLineOptions options[] =
{
	{ "+[CSCOPE.OUT path]", 
		I18N_NOOP("Opens a cscope.out file in a temporary project"), 0 },
	{ "+[CSCOPE.PROJ path | KScope project directory path]", 
		I18N_NOOP("Opens a KScope project"), 0 },
	KCmdLineLastOption
};

/**
 * Defines the programme's entry point.
 * Creates KScope's main window, and starts the event loop.
 * @param	argc	Number of command line arguments
 * @param	argv	Command line arguments
 * @return	Programme's exit value
 */
int main(int argc, char *argv[])
{
	// Create the "About" dialogue
	KAboutData aboutData( "kscope", I18N_NOOP("KScope"),
		VERSION, description, KAboutData::License_GPL,
		"(c) 2003-2005, Elad Lahav", 0, "http://kscope.sourceforge.net",
		"elad_lahav@users.sf.net");
	aboutData.addAuthor("Elad Lahav", "Maintainer",
		"elad_lahav@users.sf.net");
	aboutData.addAuthor("Albert Yosher", "Developer", "ayosher@users.sf.net");
	aboutData.addCredit("Gabor Fekete", "Bug fixes and patches",		
		"feketgai@index.hu");
	
	// Initialise command-line argument parsing
	KCmdLineArgs::init(argc, argv, &aboutData);
	KCmdLineArgs::addCmdLineOptions(options);

	// Parse command line arguments
	KCmdLineArgs* pArgs = KCmdLineArgs::parsedArgs();

	// Create the main window
	KApplication a;
	KScope* kscope = new KScope();
	a.setMainWidget(kscope);
	
	// Display the main window
	kscope->show();  

	// Handle command-line arguments
	if (pArgs->count() > 0) {
		kscope->parseCmdLine(pArgs);
	} else if (Config().getLoadLastProj()) {
		// No arguments given, reload the last project
		const QStringList slProjects = Config().getRecentProjects();
		
		if (!slProjects.empty())
			kscope->openProject(*slProjects.begin());
	}
	
	// Start the event loop
	return a.exec();
}
