/***************************************************************************
                          prefcolor.cpp  -  description
                             -------------------
    begin                : Fri Jun 13 2003
    copyright            : (C) 2003 by Elad Lahav
    email                : elad_lahav@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcolorbutton.h>
#include "prefcolor.h"
#include "kscopeconfig.h"

/**
 * Class constructor.
 * @param	pParent	The parent widget
 * @param	szName	The widget's name
 */
PrefColor::PrefColor(QWidget* pParent, const char* szName) :
	PrefColorLayout(pParent, szName)
{
	// Set initial values
	load();
		
	// Emit the modified() signal whenever any of the colour buttons changes
	// its value. This will notify the parent dialogue to enable its "Apply"
	// button
	connect(m_pFileListBackCB, SIGNAL(changed(const QColor&)), this,
		SIGNAL(modified()));
	connect(m_pFileListForeCB, SIGNAL(changed(const QColor&)), this,
		SIGNAL(modified()));
	connect(m_pTagListBackCB, SIGNAL(changed(const QColor&)), this,
		SIGNAL(modified()));
	connect(m_pTagListForeCB, SIGNAL(changed(const QColor&)), this,
		SIGNAL(modified()));
	connect(m_pQueryListBackCB, SIGNAL(changed(const QColor&)), this,
		SIGNAL(modified()));
	connect(m_pQueryListForeCB, SIGNAL(changed(const QColor&)), this,
		SIGNAL(modified()));
}

/**
 * Class destructor.
 */
PrefColor::~PrefColor()
{
}

/**
 * Reads the current settings from the configuration object, and applies them
 * the the page's widget.
 */
void PrefColor::load()
{
	m_pFileListBackCB->setColor(Config().getColor(KScopeConfig::FileList,
		KScopeConfig::Background));
	m_pFileListForeCB->setColor(Config().getColor(KScopeConfig::FileList,
		KScopeConfig::Foreground));
	m_pTagListBackCB->setColor(Config().getColor(KScopeConfig::TagList,
		KScopeConfig::Background));
	m_pTagListForeCB->setColor(Config().getColor(KScopeConfig::TagList,
		KScopeConfig::Foreground));
	m_pQueryListBackCB->setColor(Config().getColor(KScopeConfig::QueryList,
		KScopeConfig::Background));
	m_pQueryListForeCB->setColor(Config().getColor(KScopeConfig::QueryList,
		KScopeConfig::Foreground));
}

/**
 * Commits settings changes to the configuration object.
 */
void PrefColor::apply()
{
	Config().setColor(KScopeConfig::FileList, KScopeConfig::Background,
		m_pFileListBackCB->color());
	Config().setColor(KScopeConfig::FileList, KScopeConfig::Foreground,
		m_pFileListForeCB->color());
	Config().setColor(KScopeConfig::TagList, KScopeConfig::Background,
		m_pTagListBackCB->color());
	Config().setColor(KScopeConfig::TagList, KScopeConfig::Foreground,
		m_pTagListForeCB->color());
	Config().setColor(KScopeConfig::QueryList, KScopeConfig::Background,
		m_pQueryListBackCB->color());
	Config().setColor(KScopeConfig::QueryList, KScopeConfig::Foreground,
		m_pQueryListForeCB->color());
}
