/***************************************************************************
                          progressdlg.h  -  description
                             -------------------
    begin                : Thu Jul 24 2003
    copyright            : (C) 2003 by Elad Lahav
    email                : elad_lahav@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PROGRESSDLG_H
#define PROGRESSDLG_H

#include <qwidget.h>
#include <qtimer.h>
#include <kprogress.h>

/**
 * An improved progress dialog.
 * This variation of the standard KDE progress dialog displays a busy
 * indicator while waiting for the first value greater than 0.
 * @author Elad Lahav
 */

class ProgressDlg : public KProgressDialog
{
   Q_OBJECT

public: 
	ProgressDlg(QWidget* pParent = 0, const char* szName = 0);
	~ProgressDlg();

	void setValue(int);

private:
	/** When the value is 0, this timer initiates value changes that cause
		the progress-bar to move. */
	QTimer* m_pIdleTimer;

	/** A dummy value used to move the progress-bar while the value is 0. */
	int m_nIdleValue;

private slots:
	void slotShowBusy();
};

#endif
