/***************************************************************************
                             queryresultsmenu.cpp
                             -------------------
    begin                : Fri Jan 28 2005
    copyright            : (C) 2005 by Elad Lahav
    email                : elad_lahav@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <klocale.h>
#include "queryresultsmenu.h"
#include "searchresultsdlg.h"

/**
 * Class constructor.
 * @param	pParent	Parent widget
 * @param	szName	Optional object name
 */
QueryResultsMenu::QueryResultsMenu(QWidget* pParent, const char* szName) :
	QPopupMenu(pParent, szName),
	m_pItem(NULL)
{
	int i;
	
	// Default column arrangement
	for (i = 0; i < 4; i++) 
		m_nFieldToCol[i] = i;
	
	// Create the menu
	m_nCopyFileId = insertItem(i18n("Copy &File"));
	m_nCopyFuncId = insertItem(i18n("Copy F&unction"));
	m_nCopyLineId = insertItem(i18n("Copy &Line"));
	m_nCopyTextId = insertItem(i18n("Copy &Text"));
	insertSeparator();
	m_nSearchId = insertItem(i18n("Filter..."));
	m_nShowAllId = insertItem(i18n("Show All"));
	insertSeparator();
	m_nRemItemId = insertItem(i18n("&Remove Item"));

	// Interpret selected menu item
	connect(this, SIGNAL(activated(int)), this, SLOT(slotActivated(int)));
}

/**
 * Class destructor.
 */
QueryResultsMenu::~QueryResultsMenu()
{
}

/**
 * Informs the menu which column in the owner list view displays which part
 * of a query result.
 * Items that do not appear in the list should be set to "Unused".
 * @param	nFileCol	The column used to display file paths
 * @param	nFuncCol	The column used to display function names
 * @param	nLineCol	The column used to display line numbers
 * @param	nTextCol	The column used to display line text
 */
void QueryResultsMenu::setColumns(int nFileCol, int nFuncCol, int nLineCol,
	int nTextCol)
{
	m_nFieldToCol[File] = nFileCol;
	m_nFieldToCol[Func] = nFuncCol;
	m_nFieldToCol[Line] = nLineCol;
	m_nFieldToCol[Text] = nTextCol;
}

/**
 * Displays the popup-menu at the requested coordinates.
 * @param	pItem	The item on which the menu was requested
 * @param	ptPos	The requested position for the menu
 * @param	nCol	The column over which the menu was requested, -1 if no
 *					column is associated with the request
 */
void QueryResultsMenu::slotShow(QListViewItem* pItem, const QPoint& ptPos, 
	int nCol)
{
	// Save the requested item to use in signals
	m_pItem = pItem;

	// Enable only the apropriate items
	if (m_pItem == NULL) {
		setItemEnabled(m_nCopyFileId, false);
		setItemEnabled(m_nCopyFuncId, false);
		setItemEnabled(m_nCopyLineId, false);
		setItemEnabled(m_nCopyTextId, false);
		setItemEnabled(m_nRemItemId, false);
	}
	else if (nCol == m_nFieldToCol[File]) {
		setItemEnabled(m_nCopyFileId, true);
		setItemEnabled(m_nCopyFuncId, false);
		setItemEnabled(m_nCopyLineId, false);
		setItemEnabled(m_nCopyTextId, false);
		setItemEnabled(m_nRemItemId, true);
		m_nField = File;
	}
	else if (nCol == m_nFieldToCol[Func]) {
		setItemEnabled(m_nCopyFileId, false);
		setItemEnabled(m_nCopyFuncId, true);
		setItemEnabled(m_nCopyLineId, false);
		setItemEnabled(m_nCopyTextId, false);
		setItemEnabled(m_nRemItemId, true);
		m_nField = Func;
	}
	else if (nCol == m_nFieldToCol[Line]) {
		setItemEnabled(m_nCopyFileId, false);
		setItemEnabled(m_nCopyFuncId, false);
		setItemEnabled(m_nCopyLineId, true);
		setItemEnabled(m_nCopyTextId, false);
		setItemEnabled(m_nRemItemId, true);
		m_nField = Line;
	}
	else if (nCol == m_nFieldToCol[Text]) {
		setItemEnabled(m_nCopyFileId, false);
		setItemEnabled(m_nCopyFuncId, false);
		setItemEnabled(m_nCopyLineId, false);
		setItemEnabled(m_nCopyTextId, true);
		setItemEnabled(m_nRemItemId, true);
		m_nField = Text;
	}
	else {
		setItemEnabled(m_nCopyFileId, true);
		setItemEnabled(m_nCopyFuncId, true);
		setItemEnabled(m_nCopyLineId, true);
		setItemEnabled(m_nCopyTextId, true);
		setItemEnabled(m_nRemItemId, true);
		m_nField = File;
	}
	
	// Show the menu
	popup(ptPos);
}

/**
 * Emits a signal based on the selected menu item.
 * @param	nId	The item selected by the user
 */
void QueryResultsMenu::slotActivated(int nId)
{
	if (nId == m_nCopyFileId)
		emit copy(m_pItem, m_nFieldToCol[File]);
	else if (nId == m_nCopyFuncId)
		emit copy(m_pItem, m_nFieldToCol[Func]);
	else if (nId == m_nCopyLineId)
		emit copy(m_pItem, m_nFieldToCol[Line]);
	else if (nId == m_nCopyTextId)
		emit copy(m_pItem, m_nFieldToCol[Text]);
	else if (nId == m_nSearchId)
		showSearchDlg();
	else if (nId == m_nShowAllId)
		emit showAll();
	else if (nId == m_nRemItemId)
		emit remove(m_pItem);
}

/**
 * Displays a dialogue that asks the user for search criteria on a query
 * results list.
 * If the dialogue is terminated with the "OK" button, the search() signal is
 * emitted.
 */
void QueryResultsMenu::showSearchDlg()
{
	SearchResultsDlg dlg;
	QRegExp re;
	
	// Prepare the dialogue
	dlg.setColumn(m_nField);
	
	// Show the dialogue
	if (dlg.exec() == QDialog::Accepted) {
		dlg.getPattern(re);
		emit search(m_pItem, re, m_nFieldToCol[dlg.getColumn()]);
	}
}

#include "queryresultsmenu.moc"
