/***************************************************************************
                          querywidget.h  -  description
                             -------------------
    begin                : Thu May 22 2003
    copyright            : (C) 2003 by Elad Lahav
    email                : elad_lahav@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QUERYWIDGET_H
#define QUERYWIDGET_H

#include <qlistview.h>
#include <qpopupmenu.h>
#include "querywidgetlayout.h"
#include "tabwidget.h"
#include "querypage.h"
#include "historypage.h"

/**
 * A tabbed-window holding Cscope query results pages.
 * @author Elad Lahav
 */

class QueryWidget : public QueryWidgetLayout
{
   Q_OBJECT

public:
	QueryWidget(QWidget* pParent = 0, const char* szName = 0);
	~QueryWidget();

	void initQuery(uint, const QString&);
	void applyPrefs();
	void loadLockedQueries(const QString&, const QStringList&);
	void saveLockedQueries(const QString&, QStringList&);
	void showHideButtons();
	void addHistoryRecord(const QString&, uint, const QString&);
	void selectActiveHistory();

	void setHistoryEnabled(bool bEnabled) { m_bHistEnabled = bEnabled; }

public slots:
	void slotLockCurrent(bool);
	void slotLockCurrent();
	void slotRefreshCurrent();
	void slotCloseCurrent();
	void slotCloseAll();
	void slotAddQueryPage();
	void slotAddHistoryPage();
	void slotHistoryPrev();
	void slotHistoryNext();
	void slotNewQueryPage();
	
signals:
	/**
 	 * Emitted when the a lineRequested() signal is received from any of the
	 * currently open query pages. 
	 * @param	sPath	The full path of the requested source file
	 * @param	nLine	The requested line number
	 */
	void lineRequested(const QString& sPath, uint nLine);
	
	/**
	 * Emitted when the queryFinished() signal is received from any of the
     * currently open query pages.
	 */
	void queryFinished();
	
	/**
	 * Emitted when new query page is requested by user
	 */
	void newQuery();
	
private:
	/** A popup menu with query page commands (new query, lock/unlock, close
		query, etc.). */
	QPopupMenu* m_pPageMenu;
	
	/** The identifier of the lock/unlock query menu item. */
	int m_nLockMenuId;
	
	/** The identifier of the refresh query menu item. */
	int m_nRefreshMenuId;
	
	/** The identifier of the close query menu item. */
	int m_nCloseMenuId;
	
	/** The active history page. */
	HistoryPage* m_pHistPage;
	
	/** Determines whether history items should be added to the active
		history page. */
	bool m_bHistEnabled;
	
	/** The number of query pages currently open. */
	int m_nQueryPages;
	
	void setPageCaption(QueryPage*);
	
	/**
	 * @return	The active page in the tab widget
	 */
	inline QueryPage* currentPage()	{ 
		return (QueryPage*)m_pQueryTabs->currentPage();
	}
	
	/**
	 * @param	pWidget	A query page to set as the current one
	 */
	inline void setCurrentPage(QWidget* pWidget) {
		if (pWidget)
			m_pQueryTabs->setCurrentPage(m_pQueryTabs->indexOf(pWidget));
	}
		
	/**
	 * Determines if a page is a history page.
	 * @param	pPage	The page to check
	 * @return	true if the given page is a history page
	 */
	inline bool isHistoryPage(QWidget* pPage) {
		return (dynamic_cast<HistoryPage*>(pPage) != NULL);
	}
	
	void setPageLocked(QueryPage*, bool);
	void findQueryPage();
	void findHistoryPage();	
		
private slots:
	void slotRequestLine(QListViewItem*);
	void slotCurrentChanged(QWidget*);
	void slotClosePage(QWidget*);
	void slotContextMenu(const QPoint&);
	void slotContextMenu(QWidget*, const QPoint&);
};

#endif
