/***************************************************************************
                             searchresultsdlg.cpp
                             -------------------
    begin                : Thu Feb 3 2005
    copyright            : (C) 2005 by Elad Lahav
    email                : elad_lahav@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qpushbutton.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include "searchresultsdlg.h"

int SearchResultsDlg::s_nType = PlainText;
bool SearchResultsDlg::s_bCaseSensitive = true;

/**
 * Class constructor.
 * @param	pParent	The parent widget
 * @param	szName	Optional widget name
 */
SearchResultsDlg::SearchResultsDlg(QWidget* pParent, const char* szName) :
	SearchResultsLayout(pParent, szName, true, 0)
{
	// Select the last selected type radio button
	switch (s_nType) {
	case PlainText:
		m_pTextRadio->setChecked(true);
		break;
		
	case RegExp:
		m_pRegExpRadio->setChecked(true);
		break;
		
	case SimpRegExp:
		m_pSimpRegExpRadio->setChecked(true);
		break;
	}

	// Set the default value of the "Case Sensitive" check-box
	m_pCaseSenCheck->setChecked(s_bCaseSensitive);
	
	// Terminate the dialogue when either the "OK" or "Cancel" buttons are
	// clicked
	connect(m_pOKButton, SIGNAL(clicked()), this, SLOT(accept()));
	connect(m_pCancelButton, SIGNAL(clicked()), this, SLOT(reject()));
}

/**
 * Class destructor.
 */
SearchResultsDlg::~SearchResultsDlg()
{
}

/**
 * Determines the default column on which to search.
 * The column's name appears in the column combo-box.
 */
void SearchResultsDlg::setColumn(int nCol)
{
	m_pColumnCB->setCurrentItem(nCol);
}

/**
 * @return	The selected column on which to perform the search
 */
int SearchResultsDlg::getColumn()
{
	return m_pColumnCB->currentItem();
}

/**
 * Creates a regular expression based on the given pattern and type of search.
 * @param	re	A regular expression object to set
 */
void SearchResultsDlg::getPattern(QRegExp& re)
{
	QString sPattern;
	
	sPattern = m_pSearchEdit->text();
	
	// Create the regular expression
	switch (s_nType) {
	case PlainText:
		re.setPattern(QRegExp::escape(sPattern));
		re.setWildcard(false);
		break;
		
	case RegExp:
		re.setPattern(sPattern);
		re.setWildcard(false);
		break;
	
	case SimpRegExp:
		re.setPattern(sPattern);
		re.setWildcard(true);
		break;
	}
	
	// Set the case-(in)sensitive parameter
	re.setCaseSensitive(s_bCaseSensitive);
}

/**
 * Reads user values from the widgets, and closes the dialogue.
 * This slot is connected to the clicked() signal emitted by the "OK" button.
 */
void SearchResultsDlg::accept()
{
	QString sText;
		
	// Determine the selected type and store its value for the next invocation
	if (m_pTextRadio->isChecked())
		s_nType = PlainText;
	else if (m_pRegExpRadio->isChecked())
		s_nType = RegExp;
	else if (m_pSimpRegExpRadio->isChecked())
		s_nType = SimpRegExp;
	
	// Determine whether case-sensitive search is required
	s_bCaseSensitive = m_pCaseSenCheck->isChecked();
		
	// Remove white space from the search text
	sText = m_pSearchEdit->text();
	sText.stripWhiteSpace();
	if (sText.isEmpty()) {
		QDialog::reject();
		return;
	}

	// Close the dialogue
	QDialog::accept();
}

#include "searchresultsdlg.moc"

