/***************************************************************************
                             symboldlg.h
                             -------------------
    begin                : Tue Dec 28 2004
    copyright            : (C) 2004 by Elad Lahav
    email                : elad_lahav@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SYMBOLDLG_H
#define SYMBOLDLG_H

#include <qregexp.h>
#include "symbollayout.h"
#include "cscopefrontend.h"

/**
 * A dialogue that prompts the user for the text of a query.
 * When a query is requested, the user needs to fill in the required
 * information (usually a symbol name). This dialogue allows the user to
 * enter this information, as well as complete a symbol name, and use
 * previously entered text.
 * @author Elad Lahav
 */
 
class SymbolDlg : public SymbolLayout
{
	Q_OBJECT

public:
	SymbolDlg(QWidget* pParent = 0, const char* szName = 0);
	~SymbolDlg();

	enum { Reference = 0, Definition, Called, Calling, Text, Pattern,
		FileName, Including, CallTree };
	
	void setType(uint);
	void setSymbol(const QString&);
	void setHistory(QStringList&);
	QString getSymbol() const;
	uint getType() const;
	
	static QString promptSymbol(QWidget*, uint&, const QString&,
		QStringList&);
	static uint getQueryType(uint);
	
private:
	/** A cscope process used for symbol completion. */
	CscopeFrontend* m_pCscope;
	
	/** A regular expression for extracting the symbol name out of the text
		token of a Cscope record. 
		@see note in slotHintDataReady(). */
	QRegExp m_reHint;
	
	/** Displays query progress information. */
	CscopeProgress m_progress;
	
private slots:
	void slotHintClicked();
	void slotHintDataReady(FrontendToken*);
	void slotHintItemSelected(QListViewItem*);
	void slotHintOptionChanged(bool);
	void slotHintProgress(int, int);
	void slotHintFinished(uint);
	void slotTypeChanged(int);
};

#endif

