/***************************************************************************
                             tabwidget.h
                             -------------------
    begin                : Tue Feb 1 2005
    copyright            : (C) 2005 by Elad Lahav
    email                : elad_lahav@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TABWIDGET_H
#define TABWIDGET_H


#include <qtoolbutton.h>
#include <qpopupmenu.h>
#include <qmap.h>
#include <ktabwidget.h>

/**
 * An extension to the standard KDE tab widget that allows the user to select
 * a tab from a list displayed as a popup menu.
 * @author Elad Lahav
 */
class TabWidget : public KTabWidget
{
Q_OBJECT
public:
    TabWidget(QWidget* pParent = 0, const char* szName = 0);
    ~TabWidget();

private:
	/** The list button. */
	QToolButton* m_pButton;
	
	/** A popup-menu containing all tab labels. */
	QPopupMenu* m_pMenu;
	
	/** Maps menu item IDs to tab numbers. */
	QMap<int, int> m_mapMenuId;
	
private slots:
	void slotShowTabList();
	void slotShowTab(int);
};

#endif
