/***************************************************************************
 *
 * Copyright (C) 2005 Elad Lahav (elad_lahav@users.sourceforge.net)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ***************************************************************************/

#include <klocale.h>
#include "queryresultsmenu.h"
#include "searchresultsdlg.h"

/**
 * Class constructor.
 * @param	pParent	Parent widget
 * @param	szName	Optional object name
 */
QueryResultsMenu::QueryResultsMenu(QWidget* pParent, const char* szName) :
	QPopupMenu(pParent, szName),
	m_pItem(NULL)
{
	// Create the menu
	m_nViewSourceId = insertItem(i18n("&View Source"));
	insertSeparator();
	m_nCopyFuncId = insertItem(i18n("Copy F&unction"));
	m_nCopyFileId = insertItem(i18n("Copy &File"));
	m_nCopyLineId = insertItem(i18n("Copy &Line"));
	m_nCopyTextId = insertItem(i18n("Copy &Text"));
	insertSeparator();
	m_nSearchId = insertItem(i18n("Filt&er..."));
	m_nShowAllId = insertItem(i18n("&Show All"));
	insertSeparator();
	m_nRemItemId = insertItem(i18n("&Remove Item"));

	// Interpret selected menu item
	connect(this, SIGNAL(activated(int)), this, SLOT(slotActivated(int)));
}

/**
 * Class destructor.
 */
QueryResultsMenu::~QueryResultsMenu()
{
}

/**
 * Displays the popup-menu at the requested coordinates.
 * @param	pItem	The item on which the menu was requested
 * @param	ptPos	The requested position for the menu
 * @param	nCol	The column over which the menu was requested, -1 if no
 *					column is associated with the request
 */
void QueryResultsMenu::slotShow(QListViewItem* pItem, const QPoint& ptPos, 
	int nCol)
{
	// Save the requested item to use in signals
	m_pItem = pItem;

	// Enable only the apropriate items
	if (m_pItem == NULL) {
		setItemEnabled(m_nViewSourceId, false);
		setItemEnabled(m_nCopyFuncId, false);
		setItemEnabled(m_nCopyFileId, false);
		setItemEnabled(m_nCopyLineId, false);
		setItemEnabled(m_nCopyTextId, false);
		setItemEnabled(m_nRemItemId, false);
	}
	else if (nCol == 0) {
		setItemEnabled(m_nViewSourceId, true);
		setItemEnabled(m_nCopyFuncId, true);
		setItemEnabled(m_nCopyFileId, false);
		setItemEnabled(m_nCopyLineId, false);
		setItemEnabled(m_nCopyTextId, false);
		setItemEnabled(m_nRemItemId, true);
		m_nField = 0;
	}
	else if (nCol == 1) {
		setItemEnabled(m_nViewSourceId, true);
		setItemEnabled(m_nCopyFuncId, false);
		setItemEnabled(m_nCopyFileId, true);
		setItemEnabled(m_nCopyLineId, false);
		setItemEnabled(m_nCopyTextId, false);
		setItemEnabled(m_nRemItemId, true);
		m_nField = 1;
	}
	else if (nCol == 2) {
		setItemEnabled(m_nViewSourceId, true);
		setItemEnabled(m_nCopyFuncId, false);
		setItemEnabled(m_nCopyFileId, false);
		setItemEnabled(m_nCopyLineId, true);
		setItemEnabled(m_nCopyTextId, false);
		setItemEnabled(m_nRemItemId, true);
		m_nField = 2;
	}
	else if (nCol == 3) {
		setItemEnabled(m_nViewSourceId, true);
		setItemEnabled(m_nCopyFuncId, false);
		setItemEnabled(m_nCopyFileId, false);
		setItemEnabled(m_nCopyLineId, false);
		setItemEnabled(m_nCopyTextId, true);
		setItemEnabled(m_nRemItemId, true);
		m_nField = 3;
	}
	else {
		setItemEnabled(m_nViewSourceId, true);
		setItemEnabled(m_nCopyFuncId, true);
		setItemEnabled(m_nCopyFileId, true);
		setItemEnabled(m_nCopyLineId, true);
		setItemEnabled(m_nCopyTextId, true);
		setItemEnabled(m_nRemItemId, true);
		m_nField = 0;
	}
	
	// Show the menu
	popup(ptPos);
}

/**
 * Emits a signal based on the selected menu item.
 * @param	nId	The item selected by the user
 */
void QueryResultsMenu::slotActivated(int nId)
{
	if (nId == m_nViewSourceId)
		emit viewSource(m_pItem);
	else if (nId == m_nCopyFuncId)
		emit copy(m_pItem, 0);
	else if (nId == m_nCopyFileId)
		emit copy(m_pItem, 1);
	else if (nId == m_nCopyLineId)
		emit copy(m_pItem, 2);
	else if (nId == m_nCopyTextId)
		emit copy(m_pItem, 3);
	else if (nId == m_nSearchId)
		showSearchDlg();
	else if (nId == m_nShowAllId)
		emit showAll(m_pItem);
	else if (nId == m_nRemItemId)
		emit remove(m_pItem);
}

/**
 * Displays a dialogue that asks the user for search criteria on a query
 * results list.
 * If the dialogue is terminated with the "OK" button, the search() signal is
 * emitted.
 */
void QueryResultsMenu::showSearchDlg()
{
	SearchResultsDlg dlg;
	QRegExp re;
	
	// Prepare the dialogue
	dlg.setColumn(m_nField);
	
	// Show the dialogue
	if (dlg.exec() == QDialog::Accepted) {
		dlg.getPattern(re);
		emit search(m_pItem, re, dlg.getColumn());
	}
}

#include "queryresultsmenu.moc"
