/***************************************************************************
                          hdsensorslist.cpp  -  description
                             -------------------
    begin                : vie abr 26 2002
    copyright            : (C) 2002 by Miguel Novas
    email                : michaell@teleline.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <dirent.h>
#include <sys/types.h>
#include <stdlib.h>
#include <qstringlist.h>
#include <klocale.h>
#include <regex.h>

#include "sensor.h"
#include "hdsensorslist.h"


HDSensorsList::HDSensorsList(QObject *parent, const char * name): SensorsList(parent,name)
{
 process= 0;

 setDescription( QString(i18n("Hard Disks")) );

 setClass(Sensor::hdSensor);

 readConfig();

 if(!isHddTempInstalled()) return;

 QStringList disks;
 if(!getDisks(disks)) return;

 ProcessExec proc;
 proc << "hddtemp" << "-q";
 for(QStringList::Iterator it = disks.begin(); it != disks.end(); ++it ) {
   proc << *it;
 }

 if(proc.runAndWait()) {
    double value;
    QString str;
    for(QStringList::Iterator it = disks.begin(); it != disks.end(); ++it ) {
      if(getDiskInfo(proc.getStdoutData(),*it,str,value)) {
         Sensor *sensor= new Sensor(this);
         sensor->setType(Sensor::lmTemp);
         sensor->setName(*it);
         sensor->setDescription(str);
         sensor->setValueMax  (40   , Sensor::dgCelsius);
         sensor->setValueMin  ( 0   , Sensor::dgCelsius);
         sensor->setValueIdeal(value, Sensor::dgCelsius);
         sensor->setValue     (value, Sensor::dgCelsius);
         sensor->readConfig();
      }
    }
 }
}

HDSensorsList::~HDSensorsList()
{
 delete process;
}

//*************

void HDSensorsList::updateSensors()
{
 if(process) return;

 QObjectList *list= (QObjectList *)children();
 if(!list) return;

 QStringList params;
 for(Sensor *obj= (Sensor *)list->first(); obj!=0; obj= (Sensor *)list->next())
  if(obj->monitorized())
     params << obj->name();

 if(params.count()>0) {
   process= new ProcessExec;
#if ( KDE_VERSION_MAJOR >= 3 )
   *process << "hddtemp" << "-q" << params;
#else
   *process << "hddtemp" << "-q";
   for (QStringList::Iterator it= params.begin(); it!=params.end(); ++it)
    *process << *it;
#endif
   connect( process, SIGNAL(processExited(KProcess *)), this, SLOT(slotProcessExited(KProcess *)) );
   process->run();
 }
}


void HDSensorsList::slotProcessExited(KProcess *)
{
 QObjectList *list= (QObjectList *)children();

 if(!list) return;

 char *buf= process->getStdoutData();

 if( process->outputErrors() ) {
   qWarning("HddTemp Error:\n%s", buf);
 }

 char *ptr;
 regex_t *preg;
 regmatch_t pmatch[1];
 preg = (regex_t*) malloc(sizeof(regex_t));
 regcomp(preg, ": [0-9]\\+.*C$", REG_NEWLINE);
 
 for(Sensor *obj= (Sensor *)list->first(); obj!=0; obj= (Sensor *)list->next()) {
   buf= strstr(buf,obj->name());
   if(!buf) break;
   if (regexec(preg, buf, 1, pmatch, 0) == 0)
   {
     ptr = buf + pmatch[0].rm_so + 2;
     buf += pmatch[0].rm_eo;
     obj->setValue(atof(ptr), Sensor::dgCelsius); 
   }
 }
 regfree(preg);
 free(preg);
 
 delete process;
 process= 0;
}

// ***************  Static methods


bool HDSensorsList::getDiskInfo(const char *buf, QString disk, QString &name, double &value)
{
 regex_t *preg;
 regmatch_t pmatch[1];
 preg = (regex_t*) malloc(sizeof(regex_t));

 // Take disk model
 char reg_string[30];
 snprintf(reg_string, sizeof(reg_string), "%s: .*: [0-9]", disk.latin1());
 regcomp(preg, reg_string, REG_NEWLINE);
 if (regexec(preg, buf, 1, pmatch, 0) == 0)
 {	    
   name="";	   
   pmatch[0].rm_eo -= 3;
   pmatch[0].rm_so += 10;
   buf += pmatch[0].rm_so;
   while (pmatch[0].rm_so < pmatch[0].rm_eo) 
   {	    
     name += *buf;
     buf++;
     pmatch[0].rm_so++;
   }
   regfree(preg);
   name= name.stripWhiteSpace();
   if( name.length()>40 ) name= disk;
 }
 else
 {
   regfree(preg);
   free(preg);
   return false;
 }
 
 // Take disk temperature
 regcomp(preg, ": [0-9]\\+.*C$", REG_NEWLINE);
 if (regexec(preg, buf, 1, pmatch, 0) == 0)
 {	    
   value= atof(buf + pmatch[0].rm_so + 2);
   regfree(preg);
   free(preg);
 } 
 else
 {	    
   regfree(preg);
   free(preg);
   return false;
 }
 return true;
}


bool HDSensorsList::isHddTempInstalled()
{
ProcessExec proc;

 proc << "hddtemp" ;
 if(proc.runAndWait()) {
   if(strstr(proc.getStdoutData(),"ERROR")==0) return true;
   qWarning("HddTemp Error:\n%s", proc.getStdoutData());
 }
 return false;
}

bool HDSensorsList::getDisks(QStringList &disks )
{
  DIR *dir= opendir("/proc/ide");
  if(!dir) return false;
  QString str;
  struct dirent *ptr;
  while((ptr= readdir(dir))) {
    if(ptr->d_name[0]=='h' && ptr->d_name[1]=='d') {
       str.sprintf("/dev/hd%c",ptr->d_name[2]);
       disks << str;
    }
  }
  closedir(dir);
  return true;
}

// ***************

