/***************************************************************************
                          datamonitor.h  -  description
                             -------------------
    begin                : Sun Jun 17 2001
    copyright            : (C) 2001 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DATAMONITOR_H
#define DATAMONITOR_H

#include <qdatetime.h>
#include <qobject.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qtimer.h>
#include <qvaluelist.h>

#include <kio/jobclasses.h>
#include <ktempfile.h>
#include <kurl.h>

typedef struct {
  QString fileName;
  bool exists;
  QDateTime timestamp;
  uint size;
  bool ok;
  KIO::Job *job;
  KTempFile *tmp;
} data_info;

typedef struct {
  uint index;
} data_job;

class DataMonitor : public QObject {
  Q_OBJECT
  public:
    DataMonitor(const KURL& url, QObject *parent=0, const char *name=0);
    ~DataMonitor();
    virtual KURL url() const;
    virtual int getInterval() const;
    virtual QStringList readFile(const QString& fileName, bool& ok, const QString& delimiter=QString::null);
    virtual bool findIntEntry(const QString& key, QStringList& list, const QString& sep, int& value);
    virtual bool findLongEntry(const QString& key, QStringList& list, const QString& sep, long& value);
    virtual bool findFloatEntry(const QString& key, QStringList& list, const QString& sep, float& value);
    virtual bool findDoubleEntry(const QString& key, QStringList& list, const QString& sep, double& value);
    virtual bool findStringEntry(const QString& key, QStringList& list, const QString& sep, QString& value);
  public slots:
    virtual void setInterval(int secs);
    virtual void checkFiles();
  protected:
    virtual void addFile(const QString& fileName, int& index);
    virtual int index(const QString& fileName) const;
    virtual int index(KIO::Job *job) const;
    virtual QString fileName(int index);
    virtual bool exists(int index);
    virtual bool exists(const QString& fileName);
    virtual QDateTime timestamp(int index);
    virtual QDateTime timestamp(const QString& fileName);
    virtual uint size(int index);
    virtual uint size(const QString& fileName);
    virtual bool isOK(int index);
    virtual bool isOK(const QString& name);
    virtual void checkFile(int index, bool signal);
    virtual bool parseFile(int index, const QString& fileName);
  protected slots:
    virtual void checkFile(const QString& fileName);
    virtual void updateData();
  private:
    data_info fileInfo(const QString& fileName);
    KURL baseURL;
    QValueList<data_info> files;
    QTimer *timer;
    int interval;
  private slots:
    void statResult(KIO::Job *);
    void copyResult(KIO::Job *);
};

#endif
