/***************************************************************************
                          groupstatsview.h  -  description
                             -------------------
    begin                : Mon Sep 2 2002
    copyright            : (C) 2002 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GROUPSTATSVIEW_H
#define GROUPSTATSVIEW_H

#include "ksetispyview.h"

class GroupStatsView : public KSetiSpyView {
  Q_OBJECT
  public: 
    GroupStatsView(QWidget *parent=0, const char *name=0);
    ~GroupStatsView();
  protected:
    virtual void updateContent(bool force);
  private:
    bool messageVisible();
    QString group;
    group_stats *history, *stats;
  private slots:
    void showMessage(const QString& msg);
    void showMain();
    void updateGroupStats();
    void handleURL(const QString& url);
    void handleUserStatsUpdates(const user_stats* current);
    void handleGroupStatsUpdates(const group_stats* old, const group_stats* current);
};

#endif
