/***************************************************************************
                          ksetispyview.h  -  description
                             -------------------
    begin                : Tue May 29 2001
    copyright            : (C) 2001 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSETISPYVIEW_H
#define KSETISPYVIEW_H

#include <qpixmap.h>
#include <qstrlist.h>
#include <qwidget.h>

#include <kconfig.h>
#include <kpopupmenu.h>

#include "ksetispydoc.h"

class KSetiSpyView : public QWidget {
  Q_OBJECT
  public:
    enum Type {Text=0, Pixmap=1};
    KSetiSpyView(Type type, QWidget *parent=0, const char *name=0, WFlags f=0);
    ~KSetiSpyView();
    static void setDocument(KSetiSpyDoc *doc);
    virtual bool eventFilter(QObject *obj, QEvent *e);
    virtual QStringList text();
  public slots:
    virtual void readConfig(bool readGeometry);
    virtual void saveConfig(bool saveGeometry);
    virtual void updateContent();
  protected:
    static const QString unknownContent;
    virtual void mousePressEvent(QMouseEvent *click);
    QWidget *addField(QWidget *parent, const char *name);
    virtual void updateContent(bool force);
    static KSetiSpyDoc *kdoc;
    QStrList names;
    QPixmap pixmap;
    KPopupMenu *popup;
  protected slots:
    void setFieldName(const char *name, const QString& text);
    void setFieldContentText(const char *name, const QString& text);
    void setFieldContentURL(const char *name, const QString& text, const QString& url, const QString& tip
                                            , const QObject *receiver, const char *member);
    void setFieldAux(const char *name, const QString& text);
    void setFieldToolTip(const char *name, const QString& tooltip);
    virtual void textToClipboard();
    virtual void pixmapToClipboard();
    virtual void pixmapToFile();
};

#endif
