/***************************************************************************
                          logmonitor.h  -  description
                             -------------------
    begin                : Mon Jul 30 2001
    copyright            : (C) 2001 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LOGMONITOR_H
#define LOGMONITOR_H

#include <qstring.h>
#include <qtextstream.h>
#include <qvaluelist.h>

#include "setidatamonitor.h"

typedef struct {
  QDateTime done;
  QString name;
  struct {
    double ra;
    double dec;
  } start;
  double angle_range;
  double teraFLOPs;
  double cpu;
  double progress;
  struct {
    double best_score;
    uint returned;
  } spikes, gaussians, pulses, triplets;
  bool interesting;
} log_data;

bool operator==(const log_data& data1, const log_data& data2);

class LogMonitor : public DataMonitor {
  Q_OBJECT
  public:
    LogMonitor(const KURL& logURL, QObject *parent=0, const char *name=0);
    ~LogMonitor();
    virtual const QValueList<log_data> logData();
    static void writeSetiData(const QString& logURL, const seti_data&);
  signals:
    void updated();
  protected:
    static QString formatDouble(double n, int precision=3, char format='f');
    QValueList<log_data> data;
  protected slots:
    virtual void updateData();
};

#endif
