/***************************************************************************
                          performanceitem.cpp  -  description
                             -------------------
    begin                : Sat Jun 9 2001
    copyright            : (C) 2001 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qregexp.h>

#include <kglobal.h>
#include <klocale.h>

#include "performanceitem.h"

PerformanceItem::PerformanceItem(QListView *parent, const performanceItemStruct& data)
                : QListViewItem(parent)
{
  this->data = data;

  setText(0, data.name);
  setText(1, data.cache);
  setMultiplier(data.min);
}

PerformanceItem::~PerformanceItem()
{
}

QString PerformanceItem::key(int column, bool ascending) const
{
  switch(column) {
    case 0:
      return(data.name);
    case 1:
      return(cacheToKey(data.cache));
    case 2:
      return(CpFToKey(CpF));
    default:
      QListViewItem::key(column, ascending);
  }

  return(QString::null);
}

void PerformanceItem::setMultiplier(double multiplier)
{
  this->multiplier = multiplier;
  CpF = computeCpF();

  setText(2, KGlobal::locale()->formatNumber(CpF, 1));
}

double PerformanceItem::computeCpF()
{
  double x = multiplier;

  x = (x < data.min) ? data.min : x;
  x = (x > data.max) ? data.max : x;

  double y = 0.0;
  double xp = 1.0;

  for (int i = 0; i < N_COEFF; i++)
  {
    y += xp * data.coeff[i];
    xp *= x;
  }

  return(y);
}

QString PerformanceItem::cacheToKey(QString cache) const
{
  int size = 0;
  QString out;

  if(cache.contains(QRegExp("^[0-9]+\\s[Kk][Bb]$")))
  {
    cache.truncate(cache.length()-3);
    size = cache.toInt();
  }
  else if(cache.contains(QRegExp("^[0-9]+\\s[Mm][Bb]$")))
  {
    cache.truncate(cache.length()-3);
    size = 1024 * cache.toInt();
  }

  return(out.sprintf("%08d", size));
}

QString PerformanceItem::CpFToKey(double CpF) const
{
  QString out;

  return(out.sprintf("%06.0f", CpF * 1e4));
}

