/***************************************************************************
                          performanceitemreader.h  -  description
                             -------------------
    begin                : Sat Jun 9 2001
    copyright            : (C) 2001 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PERFORMANCEITEMREADER_H
#define PERFORMANCEITEMREADER_H

#include <qlistview.h>
#include <qxml.h>

#include "performanceitem.h"

class PerformanceItemReader : public QXmlDefaultHandler  {
  public:
    PerformanceItemReader(QListView *list);
    ~PerformanceItemReader();
    bool startElement(const QString &, const QString &, const QString &, const QXmlAttributes &);
    bool endElement(const QString &, const QString &, const QString &);
    bool characters(const QString &);
  private:
    QString parseCPUs(const QString &cpusStr);
    QString parseClients(const QString &clientsStr);
    QString parseMode(const QString &modeStr);
    QListView *list;
    performanceItemStruct data;
    QString cdata, core, cpus, clients, mode, memory, unit;
    int level, deg;
};

#endif
