/***************************************************************************
                          seticlientmonitor.h  -  description
                             -------------------
    begin                : Tue Jul 10 2001
    copyright            : (C) 2001 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SETICLIENTMONITOR_H
#define SETICLIENTMONITOR_H

#include <qdatetime.h>
#include <qvaluelist.h>

#include <kio/job.h>
#include <kurl.h>

#include "calibrationdatareader.h"
#include "logmonitor.h"
#include "setidatamonitor.h"
#include "sysinfomonitor.h"

typedef struct {
  enum Filter {None, All, Interesting, SNRAbove} filter;
  double threshold;
  enum Format {Bitmap, PNG, JPEG} format;
  enum Size {Default, SETIAtHome} size;
  KURL url;
} imageLogStruct;

class SetiClientMonitor : public SetiDataMonitor  {
  Q_OBJECT
  public:
    enum ClientType {Regular, VLAR};
    enum Notify {WUCompleted, InterestingGaussian};
    SetiClientMonitor(const KURL& setiURL,
                      const KURL& sysInfoURL,
                      const KURL& logURL, bool usesSETISpyLog,
                      QObject *parent=0, const char *name=0);
    ~SetiClientMonitor();
    const sys_info *sysInfo();
    KURL sysInfoURL() const;
    int currentCPU();
    QString defaultEMail() const;
    calibrationDataStruct calibration() const;
    static void loadCalibrationPresets();
    static const QValueList<calibrationDataStruct>& calibrationPresets();
    const QValueList<log_data> logData();
    bool usesSETISpyLog();
    bool writesSETISpyLog();
    bool writesCSVLog();
    imageLogStruct bestGaussianLog() const;
    imageLogStruct returnedGaussiansLog() const;
    KURL logURL() const;
    KURL command(ClientType type=Regular) const;
    QString arguments() const;
    QString filteredArguments();
    bool isRunning();
    int getPriority();
    bool launchOnStartup() const;
    bool killOnExit() const;
    bool keepAlive() const;
    bool usesCache() const;
  public slots:
    virtual void setInterval(int secs);
    virtual void updateSysInfo();
    virtual void setCurrentCPU(int index);
    virtual void setDefaultEMail(const QString& address);
    virtual void setCalibration(int preset);
    virtual void setCalibration(const calibrationDataStruct& custom);
    virtual void useSETISpyLog(bool use);
    virtual void writeCSVLog(bool write);
    virtual void writeSETISpyLog(bool write);
    virtual void setBestGaussianLog(const imageLogStruct& log);
    virtual void setReturnedGaussiansLog(const imageLogStruct& log);
    virtual void setLogURL(const KURL& url);
    virtual void setCommand(const KURL& url, ClientType type=Regular);
    virtual void setArguments(const QString& arguments);
    virtual void exec();
    virtual void kill();
    virtual void setPriority(int priority);
    virtual void setLaunchOnStartup(bool set);
    virtual void setKillOnExit(bool set);
    virtual void setKeepAlive(bool set);
    virtual void useCache(bool use);
  signals:
    void logUpdated(QObject *sender);
    void notify(QObject *sender, int notify);
  protected:
    virtual bool parseFile(int index, const QString& fileName);
    static QValueList<calibrationDataStruct> presets;
    int pid_index;
  protected slots:
    virtual void updateData();
    virtual void checkState();
  private:
    bool parsePIDFile(const QString& fileName);
    bool checkCommand(const KURL& command);
    double calibrate(double progress, double angle_range);
    SysInfoMonitor *system;
    int cpu;
    QString realAddress, defaultAddress;
    calibrationDataStruct calibrationData;
    seti_data backup;
    LogMonitor *log;
    bool writesSETISpy, writesCSV;
    imageLogStruct bestGaussian, returnedGaussians;
    KURL cmd[2];
    QString args;
    int pid;
    bool liveness;
    QTimer *livenessTimer;
    bool persistence;
    bool bootstrapped, cached;
    bool local;
  private slots:
    void logWorkUnit(const seti_data& data);
    void logGaussian(const gaussian_summary& gaussian, const imageLogStruct& log, const QString& prefix);
    void handleLogUpdates();
};

#endif
