/***************************************************************************
                          setidata.h  -  description
                             -------------------
    begin                : Mon Jun 18 2001
    copyright            : (C) 2001 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SETIDATA_H
#define SETIDATA_H

#include <qdatetime.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qvaluelist.h>

typedef struct {
  int major;
  int minor;
} version_info;

typedef struct {
  QDateTime time;
  QString string;
} date_info;

typedef struct {
  int id;
  int key;
  QString name;
  QString email;
  QString url;
  QString country;
  int postal_code;
  bool show_name;
  bool show_email;
  int venue;
  date_info registered;
  date_info last_wu;
  date_info last_result;
  int n_wus;
  int n_results;
  double total_cpu;
  int params_index;
} user_info;

typedef struct {
  QDateTime time;
  double ra;
  double dec;
} telescope_coord;

typedef struct {
  QString task;
  int version;
  QString name;
  QString data_type;
  int data_class;
  QString splitter_version;
  struct {
    double ra;
    double dec;
  } start, end;
  double angle_range;
  date_info recorded;
  struct {
    double center;
    double base;
    double sample_rate;
    int number;
  } subband;
  int fft_length;
  int ifft_length;
  QString receiver;
  int n_samples;
  version_info tape_version;
  QValueList<telescope_coord> coordinates;
} wu_info;

typedef struct {
  double power;
  double score;
  int bin;
  int fft_index;
  int fft_length;
  double chirp_rate;
} spike_detail;

typedef struct {
  double power;
  double score;
  int bin;
  double sigma;
  double true_mean;
  double chi_squared;
  int fft_index;
  int fft_length;
  double chirp_rate;
  QValueList<double> pot;
} gaussian_detail;

typedef struct {
  double power;
  double score;
  double mean;
  double period;
  int frequency_bin;
  double time_bin;
  int fft_length;
  double chirp_rate;
  QValueList<int> pot;
} pulse_detail;

typedef struct {
  double power;
  double score;
  double mean;
  double period;
  double bperiod;
  int tpotind[3][2];
  int frequency_bin;
  double time_bin;
  double scale;
  int fft_length;
  double chirp_rate;
  QValueList<int> pot;
} triplet_detail;

typedef struct {
  int ncfft;
  double cr;
  int fl;
  double cpu;
  double progress;
  int pot_frequency;
  int pot_activity;
  int outfile_pos;
  spike_detail best_spike;
  gaussian_detail best_gaussian;
  pulse_detail best_pulse;
  triplet_detail best_triplet;
} state_info;

typedef struct {
  double ra;
  double dec;
  QTime time;
} summary_coord;

typedef struct {
  summary_coord index;
  double power;
  double frequency;
  int fft_length;
  double chirp_rate;
} spike_summary;

typedef struct {
  summary_coord index;
  double peak;
  double mean;
  double frequency;
  double sigma;
  double chi_squared;
  int fft_length;
  double chirp_rate;
  double max_power;
  QValueList<int> pot;
} gaussian_summary;

typedef struct {
  summary_coord index;
  double power;
  double mean;
  double period;
  double frequency;
  int fft_length;
  double chirp_rate;
  double snr;
  double threshold;
  QValueList<int> prof;
} pulse_summary;

typedef struct {
  summary_coord index;
  double power;
  double mean;
  double period;
  double frequency;
  int fft_length;
  double chirp_rate;
} triplet_summary;

typedef struct {
  QValueList<spike_summary> spikes;
  QValueList<gaussian_summary> gaussians;
  QValueList<pulse_summary> pulses;
  QValueList<triplet_summary> triplets;
} output_data;

typedef struct {
  version_info version;
  user_info user;
  wu_info wu;
  state_info state;
  output_data output;
} seti_data;

#endif
