/***************************************************************************
                          statsserversdialog.h  -  description
                             -------------------
    begin                : Thu Jul 25 2002
    copyright            : (C) 2002 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef STATSSERVERSDIALOG_H
#define STATSSERVERSDIALOG_H

#include <qlabel.h>
#include <qbuttongroup.h>

#include <kcombobox.h>
#include <kdialog.h>
#include <kiconloader.h>
#include <klineedit.h>

#include "ksetispydoc.h"

class StatsServersDialog : public KDialog {
  Q_OBJECT
  public:
    StatsServersDialog(QWidget *parent=0, const char *name=0);
    ~StatsServersDialog();
    statsURLStruct statsURL(KSetiSpyDoc::StatsURLType type) const;
    void setStatsURL(KSetiSpyDoc::StatsURLType type, statsURLStruct datum);
  protected:
    int type() const;
    statsURLStruct currentStatsURL() const;
    bool isCustom() const;
    QString host() const;
    QString path() const;
    QString command() const;
    QString URL() const;
  protected slots:
    void setType(int type);
    void setCurrentStatsURL(const statsURLStruct& datum);
    void setCustom(bool set);
    void setHost(const QString& host);
    void setPath(const QString& path);
    void setCommand(const QString& command);
    void setURL(const QString& URL);
  private:
    int statsType;
    statsURLStruct data[N_STATS_URLS];
    QLabel *iconLabel;
    QButtonGroup *locationGroup;
    KComboBox *typeCombo, *hostCombo, *pathCombo;
    KLineEdit *commandEdit, *urlEdit;
  private slots:
    void handleLocation(int location);
};

#endif
