/***************************************************************************
                          sysinfomonitor.h  -  description
                             -------------------
    begin                : Sun Jun 17 2001
    copyright            : (C) 2001 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SYSINFOMONITOR_H
#define SYSINFOMONITOR_H

#include "datamonitor.h"

typedef struct
{
  QString vendorID;
  int cpuFamily;
  struct {
    int id;
    QString name;
  } model;
  int stepping;
  double MHz;
  int cacheSize;
  double bogoMIPS;
} cpu_info;

typedef struct
{
  struct {
    long total, free;
  } overall, swap;
  long shared, buffers;
} memory_info;

typedef struct
{
  QString name;
  QString builder;
} kernel_info;

typedef struct
{
  QValueList<cpu_info> cpus;
  memory_info memory;
  kernel_info kernel;
} sys_info;

class SysInfoMonitor : public DataMonitor {
  Q_OBJECT
  public:
    SysInfoMonitor(const KURL& procURL, QObject *parent=0, const char *name=0);
    ~SysInfoMonitor();
    const sys_info *sysInfo();
    static QString kbToString(int kb);
    static int stringToKB(QString size);
    void print();
  signals:
    void updatedSysInfo(QObject *sender, sys_info *sysInfo);
  protected:
    virtual bool parseFile(int index, const QString& fileName);
    int cpu_info_index, memory_info_index, kernel_info_index;
  protected slots:
    virtual void updateData();
  private:
    bool parseCPUFile(const QString& fileName);
    bool parseMemoryFile(const QString& fileName);
    bool parseVersionFile(const QString& fileName);
    sys_info data;
    bool ok;
};

#endif
