########################################################################
#                                                                      #
#               This software is part of the ast package               #
#           Copyright (c) 1987-2007 AT&T Knowledge Ventures            #
#                      and is licensed under the                       #
#                  Common Public License, Version 1.0                  #
#                      by AT&T Knowledge Ventures                      #
#                                                                      #
#                A copy of the License is available at                 #
#            http://www.opensource.org/licenses/cpl1.0.txt             #
#         (with md5 checksum 059e8cd6165cb4c31e351f2b69388fd9)         #
#                                                                      #
#              Information and Software Systems Research               #
#                            AT&T Research                             #
#                           Florham Park NJ                            #
#                                                                      #
#                 Glenn Fowler <gsf@research.att.com>                  #
#                                                                      #
########################################################################
:
# @(#)tar.sh (AT&T Labs Research) 1989-04-06
#
# tar -> pax interface script
#

command=tar
usage="
Usage: $command c[vwfbB[[0-9][hlm]]] [pathname ...]
       $command r[vwfbB[[0-9][hlm]]] [files ...]
       $command t[vwfbB[[0-9][hlm]]
       $command u[vwfbB[[0-9][hlm]]] [pathname ...]
       $command x[vwfblmpB[[0-9][hlm]]] [pathname ...]"

case $1 in
*[tx]*)		mode="-r" ;;
*[cru]*)	mode="-w" ;;
*)		print -u2 "$command: one of crtux must be specified$usage"; exit 1 ;;
esac
options="-P"
exec=eval
file="-o tape=0"
list=""
r_ok="1"
w_ok="1"
arg=$1
lastopt=""
shift
for opt in `echo '' $arg | sed -e 's/^ -//' -e 's/./& /g'`
do	case $opt in
	[0-9])	file="-o tape=$opt" ;;
	[hlm])	case $lastopt in
		[0-9])	file="${file}$opt" ;;
		*)	case $opt in
			h)	options="$options -L" ;;
			l)	;;
			m)	r_ok="" options="$options -pam" ;;
			esac
			;;
		esac
		;;
	[v])	options="$options -$opt" ;;
	b)	case $# in
		0)	print -u2 "$command: blocking factor argument expected$usage"; exit 1 ;;
		esac
		options="$options -b ${1}b"
		shift
		;;
	c)	r_ok="" ;;
	f)	case $# in
		0)	print -u2 "$command: file name argument expected$usage"; exit 1 ;;
		esac
		case $1 in
		-)	file="" ;;
		*)	file="-f '$1'" ;;
		esac
		shift
		;;
	p)	options="$options -pe" ;;
	r)	r_ok="" options="$options -a" ;;
	t)	w_ok="" list="1" ;;
	u)	r_ok="" options="$options -u" ;;
	w)	options="$options -o yes" ;;
	x)	w_ok="" ;;
	B)	options="$options -b 10k" ;;
	D)	case $exec in
		eval)	exec=print ;;
		*)	exec="eval args" ;;
		esac
		;;
	*)	print -u2 "$command: invalid option -$opt$usage"; exit 1 ;;
	esac
	lastopt=$opt
done
case $mode in
-r)	case $r_ok in
	"")	print -u2 "$command: options inconsistent with archive read"; exit 1 ;;
	esac
	;;
-w)	case $w_ok in
	"")	print -u2 "$command: options inconsistent with archive write"; exit 1 ;;
	esac
	case $# in
	0)	set - "." ;;
	esac
	options="$options -x ustar"
	;;
esac
case $list in
"1")	mode="" ;;
esac
case $exec in
eval)	$exec pax $mode $options $file '"$@"' ;;
*)	$exec pax $mode $options $file "$@" ;;
esac
