/***********************************************************************
*                                                                      *
*               This software is part of the ast package               *
*          Copyright (c) 1997-2011 AT&T Intellectual Property          *
*          Copyright (c) 2020-2022 Contributors to ksh 93u+m           *
*                      and is licensed under the                       *
*                 Eclipse Public License, Version 2.0                  *
*                                                                      *
*                A copy of the License is available at                 *
*      https://www.eclipse.org/org/documents/epl-2.0/EPL-2.0.html      *
*         (with md5 checksum 84283fa8859daf213bdda5a9f8d1be1d)         *
*                                                                      *
*                 Glenn Fowler <gsf@research.att.com>                  *
*                  Martijn Dekker <martijn@inlv.org>                   *
*                                                                      *
***********************************************************************/
/*
 * Glenn Fowler
 * AT&T Research
 */

#include "dlllib.h"

#if 0

/*
 * dlopen() wrapper that properly initializes LIBPATH
 * with the path of the dll to be opened
 *
 * 2009-04-15 -- if ld.so re-checked the env this would work ...
 */

void*
dllopen(const char* name, int mode)
{
	void*		dll;
	Dllinfo_t*	info;
	char*		olibpath;
	char*		path;
	char*		oenv;
	char*		nenv[2];
	char*		dir;
	char*		base;
	int		len;

	if (!environ)
	{
		nenv[0] = nenv[1] = 0;
		environ = nenv;
	}
	info = dllinfo();
	oenv = environ[0];
	olibpath = getenv(info->env);
	if (base = strrchr(name, '/'))
	{
		dir = (char*)name;
		len = ++base - dir;
	}
	else
	{
		dir = "./";
		len = 2;
		base = (char*)name;
	}
	path = sfprints("%-.*s%s%c%s=%-.*s%s%s", len, dir, base, 0, info->env, len, dir, olibpath ? ":" : "", olibpath ? olibpath : "");
	environ[0] = path + strlen(path) + 1;
	state.error = 0;
	dll = dlopen(path, mode);
	if (environ == nenv)
		environ = 0;
	else
		environ[0] = oenv;
	return dll;
}

#else

/*
 * dlopen() wrapper -- waiting for prestidigitations
 */

void*
dllopen(const char* name, int mode)
{
	state.error = 0;
	return dlopen(name, mode);
}

#endif
