/***************************************************************************
                          serverdialog.h  -  description
                             -------------------
    begin                : Sun Oct 28 2001
    copyright            : (C) 2001 by Eggert Ehmke
    email                : eggert.ehmke@berlin.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SERVERDIALOG_H
#define SERVERDIALOG_H

//Qt headers
#include <qlayout.h>
#include <qlabel.h>
#include <qtooltip.h>
#include <qspinbox.h>
#include <qgroupbox.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qcheckbox.h>

//KDE headers
#include <kdialogbase.h>
#include <klocale.h>
#include <klineedit.h>
#include <kcombobox.h>
#include <kdebug.h>
#include <kmessagebox.h>
#include <kpassdlg.h>

//KShowmail headers
#include "configelem.h"
#include "constants.h"
#include "encryption.h"
#include "kwalletaccess.h"

//radio button IDs
#define ID_BUTTON_PASSWORD_DONT_SAVE 1
#define ID_BUTTON_PASSWORD_SAVE_FILE 2
#define ID_BUTTON_PASSWORD_SAVE_KWALLET 3

/**
 * @brief Dialog to edit account options. You can not create a new account or edit the account name.
 * @author Eggert Ehmke
 * @author Ulrich Weigelt <ulrich.weigelt@gmx.de>
 */

class ServerDialog : public KDialogBase
{
   Q_OBJECT
  public:

  public:

    /**
     * General constructor
     * @param parent parent of the dialog
     * @param item account to setup
     */
    ServerDialog( QWidget* parent, ConfigElem* item = NULL );

    /**
     * Destructor
     */
    ~ServerDialog();

  private:

    /**
     * account to setup
     */
    ConfigElem* account;

    /**
     * Edit line which contains the unique account name.
     */
    KLineEdit* txtAccount;

    /**
     * Edit line which contains the server name.
     */
    KLineEdit* txtServer;

    /**
     * Combo box to choose the protocol.
     */
    KComboBox* cboProtocol;

    /**
     * Spinbox to choose the tcp port.
     */
    QSpinBox* spbPort;

    /**
     * Edit line which contains the user name.
     */
    KLineEdit* txtUser;

    /**
     * Edit line which contains the password.
     */
    KPasswordEdit* txtPassword;

    /**
     * Check box to select whether the account is active or not.
     */
    QCheckBox* chkActive;

    /**
     * Combines the radio buttons of password storage.
     */
    QButtonGroup* grpPasswordStorage;

  protected slots:

    /**
   * Connected with the password button group.
   * Enabled or disabled the password edit line.
   * @param id button identifier
     */
    void slotPasswordStorageChanged( int id );

    /**
     * Overwritten methode of KDialogBase.
     * Called if OK was clicked.
     * Stores the entered values into the given account item.
     * If no item was given, it creates a new one.
     * After then it invokes slotOk() of KDialogBase.
     */
    void slotOk();

  protected:

    /**
   * Writes the values of the account into the dialog items.
     */
    void fillDialog();
};

#endif
