//
// C++ Implementation: showmaildialog
//
// Description:
//
//
// Author: Ulrich Weigelt <ulrich.weigelt@gmx.de, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "showmaildialog.h"

ShowMailDialog::ShowMailDialog( QWidget * parent, QString & caption, bool allowHTML, QString & sender, QString & date, QString & size, QString & subject, QString & body ) :
    KDialogBase( parent, "showmaildialog", true, caption, KDialogBase::Ok | KDialogBase::Cancel | KDialogBase::User1, KDialogBase::Ok, true, KGuiItem( i18n( "Reply" ), "mail_reply" ) )
{
  //create main widget
  QWidget* mainWidget = new QWidget( this );
  setMainWidget( mainWidget );

  //this layout seperates meta data area (date, subject, and so on) from the mail body area
  QVBoxLayout* layMain = new QVBoxLayout( mainWidget, 0, spacingHint() );

  //this layouts arranges the labels and lines for the meta data
  QHBoxLayout* layMetaDatas = new QHBoxLayout( layMain, spacingHint() );
  QVBoxLayout* layLabels = new QVBoxLayout( layMetaDatas, spacingHint() );
  QVBoxLayout* layLines = new QVBoxLayout( layMetaDatas, spacingHint() );

  //create labels for meta data
  QLabel* lblSender = new QLabel( i18n( "Sender:" ), mainWidget, "lblSender" );
  layLabels->addWidget( lblSender );

  QLabel* lblDate = new QLabel( i18n( "Date:" ), mainWidget, "lblDate" );
  layLabels->addWidget( lblDate );

  QLabel* lblSize = new QLabel( i18n( "Size:" ), mainWidget, "lblSize" );
  layLabels->addWidget( lblSize );

  QLabel* lblSubject = new QLabel( i18n( "Subject:" ), mainWidget, "lblSubject" );
  layLabels->addWidget( lblSubject );

  //create edit lines to show the meta data
  KLineEdit* liSender = new KLineEdit( sender, mainWidget, "liSender" );
  liSender->setReadOnly( true );
  layLines->addWidget( liSender );

  KLineEdit* liDate = new KLineEdit( date, mainWidget, "liDate" );
  liDate->setReadOnly( true );
  layLines->addWidget( liDate );

  KLineEdit* liSize = new KLineEdit( size, mainWidget, "liSize" );
  liSize->setReadOnly( true );
  layLines->addWidget( liSize );

  KLineEdit* liSubject = new KLineEdit( subject, mainWidget, "liSubject" );
  liSubject->setReadOnly( true );
  layLines->addWidget( liSubject );

  //create text browser for the mail body
  KTextBrowser* txtBody = new KTextBrowser( mainWidget );
  txtBody->setReadOnly( true );

  if( !allowHTML )    //set HTML view or not
    txtBody->setTextFormat( KTextBrowser::PlainText );

  txtBody->setText( body );
  txtBody->setMinimumSize( WIDTH_VIEW_MAILBODY, HEIGHT_VIEW_MAILBODY );

  layMain->addWidget( txtBody );

  //store body, subject and sender for reply (slotUser1())
  m_body = body;
  m_subject = subject;
  m_sender = sender;
}

ShowMailDialog::~ShowMailDialog()
{
}

void ShowMailDialog::slotUser1( )
{
  //make copy of body to manipulate
  QString body = m_body;

  //add '>' at front of every line
  body.insert( 0, "> " );
  body.replace( "\n", "\n> " );

  //set data of the answer mail
  KURL mail;
  mail.setProtocol( "mailto" );
  mail.setPath( m_sender );
  mail.setQuery( "?subject=" + KURL::encode_string( "Re: " +  m_subject ) + "&body=" + KURL::encode_string( body ) );

  //invoke mailer
  kapp->invokeMailer( mail );
}


#include "showmaildialog.moc"
