/*
	kshutdowndcopapi.cpp - KShutDown DCOP API
	Copyright (C) 2003  Konrad Twardowski <kdtonline@poczta.onet.pl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "kshutdowndcopapi.h"

#include <dcopclient.h>
#include <krun.h>

/* constructor */

KShutDownDCOPAPI::KShutDownDCOPAPI(DCOPClient *client,
	const QString &description, const int action)
{
	_client = client;
	if (_client)
		_id = registerTask(_client->appId(), description, action);
	else
		_id = 0;
}

/* destructor */

KShutDownDCOPAPI::~KShutDownDCOPAPI()
{
	unregisterTask();
}

/* public */

bool KShutDownDCOPAPI::activate()
{
	if (!_client)
		return FALSE;

	if (_id == 0)
		return FALSE;

	QByteArray argData, replyData;
	QCString replyType;
	QDataStream argStream(argData, IO_WriteOnly);
	argStream << _id; // arg
	if (
		_client->call(
			"kshutdown",
			"KShutdownIface",
			"activateAction(int)",
			argData,
			replyType,
			replyData
		)
	)
	{
		if (replyType == "bool")
		{
			QDataStream replyStream(replyData, IO_ReadOnly);
			bool retval;
			replyStream >> retval;

			return retval;
		}
	}

	return FALSE;
}

/* private */

int KShutDownDCOPAPI::registerTask(const QString &name,
	const QString &description, const int action)
{
	_id = 0; // reset id

	if (!_client)
		return 0;

	// launch DCOP server
	if (!KRun::run("kshutdown --init", KURL::List()))
		return 0;

	QByteArray argData, replyData;
	QCString replyType;
	QDataStream argStream(argData, IO_WriteOnly);
	argStream << name << description << action; // args
	if (
		_client->call(
			"kshutdown",
			"KShutdownIface",
			"registerTask(QString,QString,int)",
			argData,
			replyType,
			replyData
		)
	)
	{
		if (replyType == "int")
		{
			// save returned task id
			QDataStream replyStream(replyData, IO_ReadOnly);
			replyStream >> _id;

			return _id; // here is our id
		}
	}

	return 0;
}

bool KShutDownDCOPAPI::unregisterTask()
{
	if (!_client)
		return FALSE;

	if (_id == 0)
		return FALSE;

	QByteArray argData;
	QDataStream argStream(argData, IO_WriteOnly);
	argStream << _id;
	if (
		_client->send(
			"kshutdown",
			"KShutdownIface",
			"unregisterTask(int)",
			argData
		)
	)
	{
		_id = 0; // reset id

		return TRUE;
	}

	return FALSE;
}
