/*
	kshutdowndcopapi.h - KShutDown DCOP API
	Copyright (C) 2003  Konrad Twardowski <kdtonline@poczta.onet.pl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __KSHUTDOWNDCOPAPI_H__
#define __KSHUTDOWNDCOPAPI_H__

#include <qstring.h>

class DCOPClient;

#define ACTION_SHUT_DOWN    1
#define ACTION_REBOOT       2
// NOT SUPPORTED BY SCHEDULER // #define ACTION_LOCK_SCREEN  3 //
#define ACTION_LOGOUT       4

/**
 * @short KShutDown DCOP API.
 * See "mmainwindows.cpp" for details.
 */
class KShutDownDCOPAPI
{
public:
	/**
	 * Constructor. Constructor automatically registers a new task.
	 * @param client An DCOP client (kapp->dcopClient())
	 * @param description A task description (e.g. "Shut down after download.")
	 * @param action An action associated with this task
	 * - Valid actions:
	 * -# ACTION_SHUT_DOWN (1)
	 * -# ACTION_REBOOT (2)
	 * -# ACTION_LOGOUT (4)
	 */
	KShutDownDCOPAPI(DCOPClient *client, const QString &description,
		const int action);

	/** Destructor. Destructor automatically unregisters the task. */
	~KShutDownDCOPAPI();

	/** Executes the action associated with this task. */
	bool activate();

	/** Returns the task ID, or @c 0 if the task is invalid. */
	int id() const { return _id; }
private:
	DCOPClient
		/** DCOP client used to call the KShutDown functions. */
		*_client;
	int _id;
	/** Registers a new task. Called automatically by the constructor. */
	int registerTask(const QString &name, const QString &description,
		const int action);
	/** Unregisters the task. Called automatically by the destructor. */
	bool unregisterTask();
};

#endif // __KSHUTDOWNDCOPAPI_H__
