/*
	links.cpp - A Link Creator
	Copyright (C) 2004  Konrad Twardowski <kdtonline@poczta.onet.pl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __LINKS_H__
#define __LINKS_H__

#include <qgrid.h>

class QComboBox;

/** @short A link (.desktop file) creator. */
class Links: public QGrid
{
	Q_OBJECT
public:
	/**
	 * Constructor.
	 * @param parent A parent widget
	 * @param name A widget name
	 */
	Links(QWidget *parent = 0, const char *name = 0);

	/**
	 * Creates a new .desktop file.
	 * @param path A path to the .desktop file
	 * @param command A .desktop file command
	 * @param icon An icon name
	 * @param name A shortcut name
	 */
	static void createLink(const QString &path, const QString &command,
		const QString &icon, const QString &name = QString::null);

	/** Removes a file @p path. */
	static void removeLink(const QString &path);
private:
	QComboBox
		*cb_location,
		*cb_type;
	QString getCurrentLocationPath() const;
	QString getCurrentTypeCommand() const;
	QString getCurrentTypeIcon() const;
private slots:
	void createLinkSlot();
	void removeLinkSlot();
};

#endif // __LINKS_H__
