/*
	mactioneditsdialog.cpp - action edit dialog
	Copyright (C) 2003  Konrad Twardowski <kdtonline@poczta.onet.pl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "mactioneditdialog.h"
#include "miscutils.h"
#include "mtip.h"

#include <qcheckbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qvgroupbox.h>

#include <klineedit.h>
#include <klocale.h>
#include <knuminput.h>
#include <kpushbutton.h>

/* constructor */

MActionEditDialog::MActionEditDialog(QWidget *parent, const char *name)
	: KDialogBase(
		Plain,
		"",
		Default | Ok | Cancel | Help,
		Ok, // default button
		parent,
		name,
		TRUE, // modal
		TRUE // separator
	),
	// init
	userCommand("")
{
	QFrame *w = plainPage();
	QVBoxLayout *l = new QVBoxLayout(w, 2);

	QVGroupBox *gb_method = new QVGroupBox("&Method", w);

	// method label
	QLabel *l_method = new QLabel(i18n("&Select a method:"), gb_method, "QLabel::l_method");

	// method combo box
	methods = new QComboBox(gb_method, "QComboBox::method");
	l_method->setBuddy(methods);
	connect(
		methods, SIGNAL(activated(int)),
		this, SLOT(methodChangeSlot(int)));

	// command label
	l_command = new QLabel(i18n("&Enter a command:"), gb_method, "QLabel::l_command");

	// command edit line
	command = new KLineEdit(gb_method, "KLineEdit::command");
	l_command->setBuddy(command);

	// tip
	MTip *t_progs = new MTip(MTip::TipType_Warning, gb_method, "MTip::t_progs");
	t_progs->setTipText(
		i18n("In most cases you need privileges to shut down system " \
			"(e.g. run /sbin/reboot or /sbin/shutdown)") + "<br><br>" +
		i18n("Manuals:") +
		"<ul>" \
		"<li><a href=\"man:/halt\">halt, poweroff, reboot</a></li>" \
		"<li><a href=\"man:/shutdown\">shutdown</a></li>" \
		"<li><a href=\"man:/xlock\">xlock</a></li>" \
		"<li><a href=\"man:/xscreensaver-command\">xscreensaver-command</a></li>" \
		"</ul>"
	);

	l->addWidget(gb_method);

	QVGroupBox *gb_commandBeforeAction = new QVGroupBox("Command &before action", w);
	runCommandBeforeAction = new QCheckBox(i18n("&Run command"), gb_commandBeforeAction, "QCheckBox::runCommandBeforeAction");
	commandBeforeAction = new KLineEdit(gb_commandBeforeAction, "KLineEdit::commandBeforeAction");
	commandBeforeActionPause = new KIntNumInput(gb_commandBeforeAction, "KIntNumInput::commandBeforeActionPause");
	commandBeforeActionPause->setLabel("[KDE 3.2] " + i18n("&Pause after run command:"));
	commandBeforeActionPause->setRange(0, 300, 1, TRUE);
	commandBeforeActionPause->setSuffix(" " + i18n("second(s)"));
	testCommandBeforeAction = new KPushButton(i18n("Test"), gb_commandBeforeAction, "KPushButton::testCommandBeforeAction");
	connect(
		testCommandBeforeAction, SIGNAL(clicked()),
		this, SLOT(testCommandBeforeActionSlot()));
	l->addWidget(gb_commandBeforeAction);

	connect(
		runCommandBeforeAction, SIGNAL(toggled(bool)),
		commandBeforeAction, SLOT(setEnabled(bool)));
	connect(
		runCommandBeforeAction, SIGNAL(toggled(bool)),
		commandBeforeActionPause, SLOT(setEnabled(bool)));
	connect(
		runCommandBeforeAction, SIGNAL(toggled(bool)),
		testCommandBeforeAction, SLOT(setEnabled(bool)));

	// focus combo box
	methods->setFocus();
}

/* destructor */

MActionEditDialog::~MActionEditDialog()
{
}

/* public */

void MActionEditDialog::setAction(const MMainWindow::What value)
{
	setCaption(mainWindow->getActionName(value));
}

void MActionEditDialog::setMethod(const MMainWindow::Method value) const
{
	methods->setCurrentItem(value);
	l_command->setEnabled(value == MMainWindow::Method_UserCommand);
	command->setEnabled(value == MMainWindow::Method_UserCommand);
	switch (value)
	{
		case MMainWindow::Method_KDE:
			command->setText("");
			break;
		case MMainWindow::Method_DefaultCommand:
			command->setText(methods->text(MMainWindow::Method_DefaultCommand));
			break;
		case MMainWindow::Method_UserCommand:
			command->setText(userCommand);
			break;
	}
}

/* protected slots */

void MActionEditDialog::slotDefault()
{
	setMethod(MMainWindow::Method_KDE);
	runCommandBeforeAction->setChecked(FALSE);
	commandBeforeAction->clear();
	commandBeforeActionPause->setValue(10);
}

/* private slots */

void MActionEditDialog::methodChangeSlot(int index)
{
	if (command->isEnabled())
		userCommand = command->text();
	setMethod((MMainWindow::Method)index);
}

void MActionEditDialog::testCommandBeforeActionSlot()
{
	MiscUtils::runShellCommand(
		commandBeforeAction->text(),
		KProcess::DontCare,
		commandBeforeActionPause->value()
	);
}
