/*
	mradiobutton.h - radio button with double click signal
	Copyright (C) 2004  Konrad Twardowski <kdtonline@poczta.onet.pl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __MRADIOBUTTON_H__
#define __MRADIOBUTTON_H__

#include <qradiobutton.h>

/**
 * @short A radio button with a double click signal.
 * Based on the ksmserver's KSMRadioButton.
 */
class MRadioButton: public QRadioButton
{
	Q_OBJECT
public:
	/**
	 * Constructor.
	 * @param text A text to display
	 * @param parent A parent widget
	 * @param name A widget name
	 */
	MRadioButton(const QString &text, QWidget *parent = 0,
		const char *name = 0);
protected:
	/**
	 * Overrided to handle mouse double click event.
	 * @param e A mouse event (not used)
	 */
	virtual void mouseDoubleClickEvent(QMouseEvent *e);
signals:
	/** This signal is emitted when the mouse is double clicked. */
	void doubleClicked();
};

#endif // __MRADIOBUTTON_H__
