/*
	mschedulertab.cpp - scheduler tab
	Copyright (C) 2004  Konrad Twardowski <kdtonline@poczta.onet.pl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "appscheduler.h"
#include "mschedulertab.h"

#include <qhbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlistview.h>
#include <qwhatsthis.h>

#include <kiconloader.h>
#include <klocale.h>
#include <kpushbutton.h>

/* constructor */

MSchedulerTab::MSchedulerTab(QWidget *parent, const char *name)
	: QWidget(parent, name),
	// init
	_initDone(FALSE),
	_listUpdate(TRUE)
{
	QVBoxLayout *l = new QVBoxLayout(this, 2);

	// list view label
	l_registeredTasks = new QLabel(i18n("Registere&d tasks:"), this,
		"QLabel::l_registeredTasks");
	l->addWidget(l_registeredTasks);

	// list
	_list = new QListView(this, "QListView::list");
	_list->setAllColumnsShowFocus(TRUE);
	_list->setItemMargin(5);
	_list->setSorting(-1); // no sort
	_list->addColumn(i18n("Name"));
	_list->addColumn(i18n("Description"));
	_list->addColumn("ID"); // no i18n
	l->addWidget(_list);
	l_registeredTasks->setBuddy(_list);
	QWhatsThis::add(_list,
		"<qt>" +
		i18n(
			"Any external application can register a KShutDown task through " \
			"the DCOP mechanism." \
			" For example, a movie player optionally can use the KShutDown " \
			"task to shut down the system after playing a movie.<br><br>" \
			"All the registered tasks are listed here. " \
			"Click <b>Remove</b> or <b>Remove All</b> " \
			"to cancel the selected task. " \
			"Click <b>Configure</b> to disable the <b>Scheduler</b>."
		) +
		"</qt>"
	);

	// task buttons layout
	QHBox *buttonsBox = new QHBox(this);
	// remove
	b_remove =
		new KPushButton(i18n("Re&move"), buttonsBox, "KPushButton::b_remove");
	b_remove->setFlat(TRUE);
	connect(
		b_remove, SIGNAL(clicked()),
		this, SLOT(removeSlot()));
	// remove all
	b_removeAll = new KPushButton(i18n("Remo&ve All"), buttonsBox,
		"KPushButton::b_removeAll");
	b_removeAll->setFlat(TRUE);
	connect(
		b_removeAll, SIGNAL(clicked()),
		this, SLOT(removeAllSlot()));
	l->addWidget(buttonsBox);
}

/* destructor */

MSchedulerTab::~MSchedulerTab()
{
}

/* public */

void MSchedulerTab::initOnDemand()
{
	if (_initDone)
		return;

	b_remove->setIconSet(SmallIcon("editdelete"));
	b_removeAll->setIconSet(SmallIcon("editdelete"));

	_initDone = TRUE;
}

void MSchedulerTab::update()
{
	if (!listUpdate())
		return;

	_list->clear();

	int i;
	QListViewItem *lvi;
	QString n;
	QValueList<AppInfo *>::iterator it =
		mainWindow->appScheduler()->list()->begin();
	QValueList<AppInfo *>::iterator end =
		mainWindow->appScheduler()->list()->end();

	for (; it != end; ++it)
	{
		n = (*it)->getName();
		lvi = new QListViewItem(
			_list,
			n,
			(*it)->getDescription(),
			QString::number((*it)->getId())
		);

		// appname-pid -> appname
		i = n.find("-");
		if (i > 0)
			n.truncate(i);
		// set icon
		lvi->setPixmap(0, SmallIcon(n));
	}
	// disable if no items in the list
	i = _list->childCount();
	l_registeredTasks->setEnabled(i);
	_list->setEnabled(i);
	b_remove->setEnabled(i);
	b_removeAll->setEnabled(i);
}

/* private slots */

void MSchedulerTab::removeAllSlot()
{
	setListUpdate(FALSE);
	QListViewItemIterator lvii(_list);
	while (lvii.current())
	{
		// column "2" = ID
		mainWindow->appScheduler()->unregisterTask(
			lvii.current()->text(2).toInt()
		);
		++lvii;
	}
	setListUpdate(TRUE);
	mainWindow->updateSchedulerTab();
}

void MSchedulerTab::removeSlot()
{
	QListViewItem *lvi = _list->currentItem();
	// column "2" = ID
	if (lvi)
		mainWindow->appScheduler()->unregisterTask(lvi->text(2).toInt());
}
