/*
	mstatstab.h - statistics tab
	Copyright (C) 2003  Konrad Twardowski <kdtonline@poczta.onet.pl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __MSTATSTAB_H__
#define __MSTATSTAB_H__

#include <qwidget.h>

class QProcess;
class QTextEdit;

class KPushButton;

/** @short Statistics tab (output from the `w' command). */
class MStatsTab: public QWidget
{
	Q_OBJECT
public:
	/**
	 * Constructor.
	 * @param parent A parent widget
	 * @param name A widget name
	 */
	MStatsTab(QWidget *parent = 0, const char *name = 0);

	/** Destructor. */
	virtual ~MStatsTab();

	/** Initializes widgets when user click on the "Scheduler" tab. */
	void initOnDemand();
private:
	bool _initDone;
	KPushButton *b_refresh;
	QProcess *_process;
	QString _buf;
	QTextEdit *te_output;
	void killProcess() const;
private slots:
	void processExitSlot();
	void readStdoutSlot();
	void refreshSlot();
};

#endif // __MSTATSTAB_H__
