/*
	mtip.cpp - tip label
	Copyright (C) 2003  Konrad Twardowski <kdtonline@poczta.onet.pl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "mtip.h"

#include <kiconloader.h>

/* constructor */

MTip::MTip(const TipType tipType, QWidget *parent, const char *name)
	: KActiveLabel(parent, name),
	// init
	_iconPath(""),
	_text(""),
	_type(TipType_Normal)
{
	setFrameStyle(StyledPanel | Sunken);
	setMargin(2);
	setTipType(tipType);
	setTipText("");
}

/* destructor */

MTip::~MTip()
{
}

/* public */

void MTip::setTipText(const QString &value)
{
	// valign and "center" ?
	QString leftCell = "<td align=\"center\" valign=\"center\">";
	if (_iconPath.isEmpty())
		leftCell += "&nbsp;";
	else
		leftCell += "<img src=\"" + _iconPath + "\">";
	leftCell += "</td>";
	_text = value;
	setText(
		"<qt>" \
		"<table border=\"0\" cellpadding=\"0\" cellspacing=\"2\">" \
		"<tr>" + leftCell + "<td>" + _text + "</td></tr>" \
		"</table>" \
		"</qt>"
	);
}

void MTip::setTipType(const TipType value)
{
	_type = value;
	switch (_type)
	{
		case TipType_Info:
			_iconPath = getIconPath("messagebox_info");
			setPaletteBackgroundColor(QColor(255, 255, 255)); // white
			setPaletteForegroundColor(QColor(0, 0, 255)); // blue
			break;
		case TipType_Normal:
			_iconPath = getIconPath("messagebox_info");
			setPaletteBackgroundColor(QColor(255, 255, 220)); // tool tip color
			setPaletteForegroundColor(QColor(0, 0, 0)); // black
			break;
		case TipType_Warning:
			_iconPath = getIconPath("messagebox_warning");
			setPaletteBackgroundColor(QColor(255, 168, 88)); // light orange
			setPaletteForegroundColor(QColor(0, 0, 0)); // black
			break;
		default:
			_iconPath = "";
	}
}

/* private */

QString MTip::getIconPath(const QString &name)
{
	return
		KGlobal::iconLoader()->iconPath(
			name,
			KIcon::NoGroup,
			KIcon::SizeLarge
		);
}
