/*
	mtip.h - tip label
	Copyright (C) 2003  Konrad Twardowski <kdtonline@poczta.onet.pl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __MTIP_H__
#define __MTIP_H__

#include <kactivelabel.h>

/** @short A tooltip widget based on the @c KActiveLabel widget. */
class MTip: public KActiveLabel
{
public:
	/** Tip types. */
	enum TipType {
		/** Info tip */
		TipType_Info,
		/** Normal tip */
		TipType_Normal,
		/** Warning tip */
		TipType_Warning
	};

	/**
	 * Constructor.
	 * @param tipType A tip type
	 * @param parent A parent widget
	 * @param name A widget name
	 */
	MTip(const TipType tipType, QWidget *parent = 0, const char *name = 0);

	/** Destructor. */
	virtual ~MTip();

	/** Sets tip text to @p value. */
	void setTipText(const QString &value);

	/** Sets tip type to @p value. */
	void setTipType(const TipType value);
private:
	QString
		_iconPath,
		_text;
	TipType _type;
	// returns a full path of the specified icon
	QString getIconPath(const QString &name);
};

#endif // __MTIP_H__
