/***************************************************************************
 *   Copyright (C) 2004-2005 by Giovanni Venturi                           *
 *   gventuri73@tiscali.it                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/

#include <linux/if_ether.h>
#include <netinet/in.h>

#include <qstring.h>
#include <qstringlist.h>

#include <klocale.h>
#include <kdebug.h>

#include "../packet.h"
#include "../packetstructures.h"
#include "ethernet2.h"

Ethernet2Frame::Ethernet2Frame(Packet *packet)
{
  m_packet = packet;
}


QString Ethernet2Frame::sourceAddress() const
{
  if (m_packet)
  {
    struct ethhdr *eth = (struct ethhdr *) m_packet->getPacket();

    return QString("%1:%2:%3:%4:%5:%6").arg(eth->h_source[0], 0, 16).arg(eth->h_source[1], 0, 16)
        .arg(eth->h_source[2], 0, 16).arg(eth->h_source[3], 0, 16).arg(eth->h_source[4], 0, 16)
        .arg(eth->h_source[5], 0, 16);
  }
  else
    return "";
}


QString Ethernet2Frame::destinationAddress() const
{
  if (m_packet)
  {
    struct ethhdr *eth = (struct ethhdr *) m_packet->getPacket();

    return QString("%1:%2:%3:%4:%5:%6").arg(eth->h_dest[0], 0, 16).arg(eth->h_dest[1], 0, 16)
        .arg(eth->h_dest[2], 0, 16).arg(eth->h_dest[3], 0, 16).arg(eth->h_dest[4], 0, 16)
        .arg(eth->h_dest[5], 0, 16);
  }
  else
    return "";
}


QStringList Ethernet2Frame::headerLines() const
{
  QStringList list;

  if (m_packet)
  {
    struct ethhdr *eth = (struct ethhdr *) m_packet->getPacket();
    list << i18n("Ethernet2 Frame Field", "MAC Source Address: %1:%2:%3:%4:%5:%6").arg(eth->h_source[0], 0, 16).arg(eth->h_source[1], 0, 16)
        .arg(eth->h_source[2], 0, 16).arg(eth->h_source[3], 0, 16).arg(eth->h_source[4], 0, 16)
        .arg(eth->h_source[5], 0, 16);
    list << i18n("Ethernet2 Frame Field", "MAC Destination Address: %1:%2:%3:%4:%5:%6").arg(eth->h_dest[0], 0, 16).arg(eth->h_dest[1], 0, 16)
        .arg(eth->h_dest[2], 0, 16).arg(eth->h_dest[3], 0, 16).arg(eth->h_dest[4], 0, 16).arg(eth->h_dest[5], 0, 16);
    list << i18n("Ethernet2 Frame Field", "Protocol Type: 0x%1").arg(htons(eth->h_proto), 0, 16);
  }

  return list;
}


unsigned short Ethernet2Frame::protocol() const
{
  struct ethhdr *eth = (struct ethhdr *) m_packet->getPacket();

  return htons(eth->h_proto);
}
