/***************************************************************************
 *   Copyright (C) 2004-2005 by Giovanni Venturi                           *
 *   gventuri73@tiscali.it                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/

#ifndef KSNIFFERMAINWIDGET_H
#define KSNIFFERMAINWIDGET_H

#include <qwidget.h>
#include <qmutex.h>

/**
 * This class contains the stuff to create and manage the QListView containing the
 * captured packet listed
 *
 * @author Giovanni Venturi
 */

class QSplitter;
class QListView;
class QListViewItem;
class QString;
class QVBoxLayout;

class PacketManager;

class KURL;
class KSnifferViewItem;

class KSnifferMainWidget : public QWidget
{
  Q_OBJECT

public:
  KSnifferMainWidget( QWidget* parent = 0, const char* name = 0 );
  ~KSnifferMainWidget();

  /**
   * Random 'get' function
   */
  QString currentURL();

  /**
   * Random 'set' function accessed by DCOP
   */
  virtual void openURL(const QString& url);

  /**
   * Random 'set' function
   */
  virtual void openURL(const KURL& url);

  /**
   * Print this view to any medium -- paper or not
   */
  void print(QPainter *, int height, int width);

  /**
   * Add a line into the first QListView. It needs 6 QString items since
   * whe have 6 column to show 6 several detail types.
   */
  void addListViewItem( const QString& item1, const QString& item2,
                        const QString& item3, const QString& item4,
                        const QString& item5, const QString& item6 );

  /**
   * Delete all the element from the views
   */
  void clearView();

  /**
   * Let sort or not from extern class
   */
  void setSortList(bool value);

signals:
  /**
   * Use this signal to change the content of the statusbar
   */
  void signalChangeStatusbar(const QString& text);

  /**
   * Use this signal to change the content of the caption
   */
  void signalChangeCaption(const QString& text);


private:
  QSplitter* m_splitter;
  QListView* m_list;
  QListView* m_detail;
  bool m_bExpanding0;         // true if the detail line 0 has to be expanded
  bool m_bExpanding1;         // true if the detail line 1 has to be expanded

protected:
  QVBoxLayout* m_mainViewLayout;

private:
  bool m_firstInsert;              // true if we have to insert the first element into the list
  KSnifferViewItem *m_lastElem;    // point to the last element inserted into the list
  PacketManager *m_packetManager;  // needed to get and display all packet details

private slots:
  void slotOnURL(const QString& url);
  void slotSetTitle(const QString& title);

  /**
   * Use this slot to set to expande state the the m_detail list
   */
  void setExpand();

  /**
   * Use this slot to set to collapsed state the the m_detail list
   */
  void setCollapse();

protected slots:
  /**
   * Use this slot to view captured packets
   */
  void displayPacket(int ord, PacketManager *packetManager);

  /**
   * Use this slot to show details about a captured packet
   */
  void showDetails( QListViewItem * item );

private:
  void viewSubtree(QStringList::Iterator &it, QListViewItem **itemFrame, QListViewItem **subitemFrame);

};

#endif // KSNIFFERMAINWIDGET_H
