/***************************************************************************
 *   Copyright (C) 2004-2007 by Giovanni Venturi                           *
 *   giovanni@ksniffer.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/

#include <unistd.h>
#include <sys/types.h>

#include <kuniqueapplication.h>
#include <dcopclient.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kmessagebox.h>

#include "ksniffer.h"
#include "version.h"

static const char description[] =
  I18N_NOOP("A KDE application for sniffing your computer network");

static const char version[] = APPVER;

static KCmdLineOptions options[] =
{
  //{ "+[URL]", I18N_NOOP( "Document to open" ), 0 },
  KCmdLineLastOption
};

int main(int argc, char **argv)
{
  KAboutData about("ksniffer", "KSniffer", version, description,
                   KAboutData::License_GPL, "(C) 2004-2007 Giovanni Venturi");
  //about.addAuthor( "Giovanni Venturi", 0, "giovanni@ksniffer.org" );
  about.addAuthor( "Giovanni Venturi", I18N_NOOP("Original author and core developer"), "giovanni@ksniffer.org", "http://www.ksniffer.org/" );
  about.addCredit( "Alexander Neundorf", I18N_NOOP("The code for detecting network devices"), "neundorf@kde.org" );
  about.addCredit( "Bram Schoenmakers", I18N_NOOP("Some patches and fixes"), "bramschoenmakers@kde.nl" );
  about.addCredit( I18N_NOOP("Gerald Combs and all Ethereal authors"),
    I18N_NOOP("A good sniffer application has to take a look at this great huge application"), "", "http://www.ethereal.com/" );
  about.addCredit( "Luigi Toscano", I18N_NOOP("Testing, supporting, the code to stop capture in safe way"),
    "luigi.toscano@tiscali.it" );
  about.addCredit( "Pino Toscano", I18N_NOOP("Testing, supporting, good patches and ideas"),
    "toscano.pino@tiscali.it" );

  KCmdLineArgs::init(argc, argv, &about);
  KCmdLineArgs::addCmdLineOptions(options);
  KUniqueApplication app;

  // register ourselves as a dcop client
  app.dcopClient()->registerAs(app.name(), false);

  KSniffer *mainWidget = 0;

  // see if we are starting with session management
  if (app.isRestored())
  {
    RESTORE(KSniffer);
  }
  else
  {
    // no session... just start up normally
    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
    if (args->count() == 0)
    {
      mainWidget = new KSniffer();
      app.setMainWidget( mainWidget );
      mainWidget->show();
      args->clear();
    }
    else
    {
      int i = 0;
      for (; i < args->count(); i++)
      {
        KSniffer *mainWidget = new KSniffer();
        mainWidget->show();
        mainWidget->load(args->url(i));
      }
    }
    args->clear();
  }

  return app.exec();
}
