 /***************************************************************************
  *   Copyright (C) 2004-2007 by Giovanni Venturi                           *
  *   giovanni@ksniffer.org                                                 *
  *                                                                         *
  *   This program is free software; you can redistribute it and/or modify  *
  *   it under the terms of the GNU General Public License as published by  *
  *   the Free Software Foundation; either version 2 of the License, or     *
  *   (at your option) any later version.                                   *
  *                                                                         *
  *   This program is distributed in the hope that it will be useful,       *
  *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
  *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
  *   GNU General Public License for more details.                          *
  *                                                                         *
  *   You should have received a copy of the GNU General Public License     *
  *   along with this program; if not, write to the                         *
  *   Free Software Foundation, Inc.,                                       *
  *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.          *
  ***************************************************************************/

#ifndef SNIFF_H
#define SNIFF_H

#if !defined(__FreeBSD__) && !defined(__NetBSD__) && !defined(__OpenBSD__) && \
    !defined(__bsdi__) && !defined(__APPLE__) && !defined(_WIN32) && \
    !defined(__CYGWIN__)
# define MUST_DO_SELECT
#endif

#include <syslog.h>
#include <pcap.h>

#include <fstream>

#include "../packetstructures.h"

#include "../errorcode.h"

#define APPNAME "[sniff] - "

  pcap_t *m_pcapfp;             // a pointer to pcap_t structure
  pcap_dumper_t *m_pdump;       // a pointer to dump packets on file
  packetType m_packet[PKTMAX];

  int m_canSniff;               // true if it can sniff
  int m_bSniffing;              // true if it's sniffing
  long int m_countPackets;      // counted packets number
  int m_returnValue = 0;        // the return value of the application: 0 if all ok
  bool m_bPauseSniffing;        // true if paused capturing

  /**
   * Error constant for \ref getPacketFromFile().
   */
  enum {BAD_FORMAT_FILE = -10, NO_RESULT_AVAILABLE = 0, NO_FILE_SELECTED = 10, RIGHT_FORMAT_FILE = 20};

  #ifdef MUST_DO_SELECT
    #define CAP_READ_TIMEOUT 250
    int m_pcap_fd;
    fd_set m_fdset;
    struct timeval m_fdtimeout;
  #endif

  /**
   * writing into the syslog
   */
   void logging(char *str);
   void loggingInt(char *str, int i);
   void loggingString(char *str, char *str2);

  /**
   * prepare the sniffing parameters: interface, ...
   */
  void initSniff(ParseConfig *config);

  /**
   * Start sniffing according the xml configuration file
   */
  void startSniffing(ParseConfig *config);

  /**
   * Calculate the frame size (hdrLen) of the sniffed packet (pHandler)
   */
  void setHeaderData(pcap_t *pHandler, int &frameType, int &hdrLen);

  /**
   * Stop sniffing on the selected interface
   */
  void stopSniffing();

  /**
   * Let you known if sniffing thread is active.
   *
   * @return
   *   - true    --> the sniffing thread is active
   *   - false   --> the sniffing thread is not active
   */
  int isSniffing();

  /**
   * signal handler for SIGINT, SIGTERM and SIGUSR1 signals
   */
  void exitHandler( int );
  void pauseContinueSniffHandler( int );

#endif // SNIFF_H
