/***************************************************************************
 *   Copyright (C) 2004-2007 by Giovanni Venturi                           *
 *   giovanni@ksniffer.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/

#ifndef TCPPROTOCOL_H
#define TCPPROTOCOL_H

class Packet;
class ProtocolNameList;
class QString;
class QStringList;

#include <netinet/in.h>

class TcpProtocol
{
public:
  TcpProtocol(Packet *packet, ProtocolNameList *pnl);

  uint16_t sourcePort() const;
  uint16_t destinationPort() const;
  uint16_t win() const;
  uint16_t sequenceNumber() const;
  uint16_t dataLength() const;
  QString detectProtocol( uint16_t const& proto ) const;
  QString flags() const;

  QStringList headerLines() const;

private:
  Packet *m_packet;
  ProtocolNameList *m_protocolNameList;
};

#endif
