/***************************************************************************
 *   Copyright (C) 2004 by Manuel Prez Lpez                              *
 *   mapelo@ieduca.net http://www.ieduca.net/                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "ksociograma.h"
#include "sociometrictest.h"


#include <qfiledialog.h>
#include <kfiledialog.h> 

#include <qlineedit.h>
#include <qradiobutton.h>
#include <qtable.h>
#include <qtabwidget.h>
#include <qpushbutton.h>
#include <qcombobox.h>


#include <qmessagebox.h>
#include <qregexp.h>

#include "sociogram.h"

#include <qobject.h>
#include <kprinter.h>
#include <qprinter.h>
#include <qpainter.h>
#include <qtextedit.h>

#include <qtextstream.h> // para las qWarning

#include <kaboutapplication.h>
#include "questionnaire.h"


#include <klocale.h>
#include <qtoolbar.h>
#include <kmainwindow.h>
#include <qtoolbutton.h>
#include <qimage.h>
#include <qpopupmenu.h>
#include <qmenubar.h>
#include <kaction.h>
#include <kstdaction.h>
#include <kactioncollection.h>
#include <kmainwindow.h>
#include <kstandarddirs.h>
#include <kurlrequester.h>
#include <kurl.h>
#include <qspinbox.h>

#include <qpaintdevicemetrics.h>
//#include <iostream.h> // para sacar con cout


ksociograma::ksociograma(KMainWindow* parent, const char* name, WFlags fl, sociometricTest *myTest2, KAction *actOpenNew2, KAction *actOpen2, KAction *actSave2, KAction *actPrint2, KAction *actQuit2, KAction *actOpenQuestionnaire2 )
    : frmKsociogramaWidget(parent, name, fl), myTest(myTest2) , actOpenNew(actOpenNew2), actOpen(actOpen2), actSave(actSave2), actPrint(actPrint2), actQuit(actQuit2), actOpenQuestionnaire(actOpenQuestionnaire2)
    
{

newAccess();
setTasksAndPages();


//ajustamos la relacion x/y a 297/210 para tamao A4
int x,y;
y=tabWidget1->height()-TabPage1->height();
x=qRound((double)y/(double)210*297);

// crea y muestra el sociograma individual
myTest->setStudentShow(0);
const char *ts = "sIndividual";
myPainterSociogramIndividual = new QPainter(tabWidget1);
individualSociogram = new sociogram (TabPage7, ts, myPainterSociogramIndividual, myTest);
individualSociogram->resize( x, y);
individualSociogram->initialValues();
//centramos el sociograma
individualSociogram->setGeometry( (tabWidget1->width()-x)/2, 0, x, y );
individualSociogram->show();


// crea y muestra el sociograma de grupo
const char *rs="sGroup";
myPainterSociogramGroup = new QPainter(tabWidget1);
groupSociogram = new sociogram (TabPage8, rs , myPainterSociogramGroup, myTest);
groupSociogram->resize( x, y);
groupSociogram->initialValues();
//centramos el sociograma
groupSociogram->setGeometry( (tabWidget1->width()-x)/2, 0, x, y );
groupSociogram->show();




// esto est implementado despues de crear individualSociogram para que sean visibles encima !!!!!!!!!!!!!!!!
label1TabPage7 = new QLabel ( i18n("Select a student to show:"), TabPage7, 0, 0 );
label1TabPage7->setGeometry ( 665, 6, 315, 20 );
label1TabPage7->show();

comboBox1TabPage7 = new QComboBox ( TabPage7, 0 );
comboBox1TabPage7->setGeometry ( 665, 43, 315, 20 );
comboBox1TabPage7->show();
QObject::connect( comboBox1TabPage7, SIGNAL(activated(int)), this, SLOT(slotStudentSelected(int) ) );





// hay que implementar esto despues del groupSociogram para que sean visibles encima !!!!!!!!!!!!!!!!
label1TabPage8 = new QLabel ( i18n("Group sociogram type to show:"), TabPage8, 0, 0 );
label1TabPage8->setGeometry ( 665, 6, 315, 20 );
label1TabPage8->show();

comboBox1TabPage8 = new QComboBox ( TabPage8, 0 );
comboBox1TabPage8->setGeometry ( 665, 43, 315, 20 );
comboBox1TabPage8->show();
QObject::connect( comboBox1TabPage8, SIGNAL(activated(int)), this, SLOT(slotGroupSociogramSelected(int) ) );




}



ksociograma::~ksociograma()
{
}












/*$SPECIALIZATION$*/




































void ksociograma::loadTest()
{
    KFileDialog* fd = new KFileDialog( QString::null,"*",this,0,TRUE,0 );
    fd->show();	
    if ( fd->exec() == KDialog::Accepted ) 
    {
       KURL myURL = fd->selectedURL();
       //QString sURL = myURL.prettyURL(); //si empieza en file:/ o ftp://
       QString sURL = myURL.path(); //no comienza en file:/ o ftp://
       
       myTest->CargaDatosGeneralesTest (sURL);
       myTest->CargaDatosGeneralesGrupo (sURL);
       myTest->CargaBaseDatosAlumnos (sURL);
       myTest->CargaRespuestas (sURL);
       myTest->loadPosition(sURL);
       
       //cargamos la localizacion del test
       myTest->setRutaFicheroTest(sURL);

       disableWidgets();
       setTasksAndPages();
       
       //desactivamos botones al ser nuevo y el flag changetest
       myTest->isChangedTest=FALSE;
       actSave->setEnabled(FALSE);
     } 
     delete fd;


     
}





void ksociograma::slotStudentTableClicked(int row, int col, int button, const QPoint &mousePos)
{
QString srow;
srow = srow.setNum(row+1);
lineEdit8->setText( srow );
lineEdit9->setText( table1->text(row,0) );
bool ok;
spinBox2->setValue( table1->text(row,1).toInt( &ok, 10 ) );
if (table1->text(row,2) == i18n("Male")) radioButton7->setChecked(TRUE);
if (table1->text(row,2) == i18n("Female")) radioButton8->setChecked(TRUE);
if (table1->text(row,2) == "") radioButton9->setChecked(TRUE);
lineEdit11->setText( table1->text(row,3) );
}


















// slot para actualizar un sujeto en la tabla del tabPage2
void ksociograma::slotUpdateStudent()
{

int row;

row=0;
//Si no nos ha llegado numero de registro, estamos en modo introduccion

if ( lineEdit8->text().isEmpty())
{

        // preparamos e imprimimos el numero del puntero de alumno
        // para el formulario de introduccin de datos, pero para el siguiente
        // que encontremos con nombre de alumno vacio
        while  (row <= table1->numRows()-1 ) 
        {
        if (table1->text(row,0).isEmpty() ) break;
	else row++;
        }

}
// en este caso si llega el numero de registro, y estamos en modo edicion
else
{
	bool ok;
	row = lineEdit8->text().toInt( &ok, 10 )-1;
}




//lineEdit7: numero total de alumno del grupo
//lineEdit9: nombre
//lineEdit10: edad
//lineEdit11: identificativo





// comprueba si se ha llegado al final de todos los alumnos del grupo
if (row+1 > myTest->getNumeroAlumnosGrupo()) 
QMessageBox::critical( this, "KSociograma",
    i18n("All the data for students have been completed.\nIt's impossible to insert more.\nTo insert more students, pick tab 'Step 2' and increment the number of students into the group.") );
else
{


// trasladamos la informacin al table1
table1->setText(row,0,lineEdit9->text());


QString s;
table1->setText(row,1,s.setNum(spinBox2->value()));
if (radioButton7->isChecked () ) table1->setText(row,2,i18n("Male"));
if (radioButton8->isChecked () ) table1->setText(row,2,i18n("Female"));
if (radioButton9->isChecked () ) table1->setText(row,2, QString::null);
table1->setText(row,3,lineEdit11->text());

//guardamos la informacin en myTest
myTest->isChangedTest=TRUE; 
actSave->setEnabled(TRUE);
myTest->setNombreAlumno(row+1,lineEdit9->text());
myTest->setEdadAlumno(row+1,spinBox2->value());
if (radioButton7->isChecked () ) myTest->setSexoAlumno(row+1,"Hombre");
if (radioButton8->isChecked () ) myTest->setSexoAlumno(row+1,"Mujer");
if (radioButton9->isChecked () ) myTest->setSexoAlumno(row+1,QString::null);
myTest->setIdentificativoAlumno(row+1,lineEdit11->text());
setTasksAndPages();



// borramos los campos de introduccin de datos
lineEdit8->setText( QString::null);
lineEdit9->setText( QString::null);
radioButton7->setChecked(FALSE);
radioButton8->setChecked(FALSE);
radioButton9->setChecked(TRUE);
spinBox2->setValue(0);
lineEdit11->setText( QString::null);
}

}























// ha cambiado el estado del radioButton10 referido al criterio propio
void ksociograma::slotCustomItems(int)
{

if (radioButton10->isChecked())
   {
   /*
   textLabel101->setEnabled (TRUE);
   textLabel102->setEnabled (TRUE);
   textLabel103->setEnabled (TRUE);
   textLabel104->setEnabled (TRUE); */
   lineEdit12->setEnabled (TRUE);
   lineEdit13->setEnabled (TRUE);
   lineEdit14->setEnabled (TRUE);
   lineEdit15->setEnabled (TRUE);
   
   }
else 
   {/*
   textLabel101->setEnabled(FALSE);
   textLabel102->setEnabled(FALSE);
   textLabel103->setEnabled(FALSE);
   textLabel104->setEnabled(FALSE); */
   lineEdit12->setEnabled(FALSE);
   lineEdit13->setEnabled(FALSE);
   lineEdit14->setEnabled(FALSE);
   lineEdit15->setEnabled(FALSE);
   }
}






//se selecciona un sujeto para mostrarse en los sociogramas individuales
void ksociograma::slotStudentSelected(int)
{
myTest->setStudentShow(comboBox1TabPage7->currentItem ()+1);
//individualSociogram->update(); //realiza un evento paint
individualSociogram->repaint(); //realiza un evento paint inmediatamente
}


//se selecciona un tipo de estadistico para mostrarse en los parametros sociometricos
void ksociograma::slotSociometricParameterSelected(int value)
{
/*
valor de value
( "Status de elecciones (Sp)", 0 );
( "Status de rechazos (Sn)", 1 );
( "Expansibidad postiva (Ep)", 2 );
( "Expansibidad negativa (En)", 3 );
( "Percepcin de elecciones (Pp)", 4 );
( "Percepcin de rechazos (Pn)", 5 );
( "Impresin de elecciones (Ip)", 6 );
( "Impresin de rechazos (In)", 7 );
*/

QString sociometricParam;
switch(value) 
{ 
   case 0: sociometricParam="Sp";break;
   case 1: sociometricParam="Sn";break;
   case 2: sociometricParam="Ep";break;
   case 3: sociometricParam="En";break;
   case 4: sociometricParam="Pp";break;
   case 5: sociometricParam="Pn";break;
   case 6: sociometricParam="Ip";break;
   case 7: sociometricParam="In";break;
   default: sociometricParam = QString::null; 
}


QString s;

s = s.number(myTest->getParam_Med(sociometricParam),'f',3);
textLabelMedia->setText(i18n("Average: ")+s);

s = s.number(myTest->getParam_Desv(sociometricParam),'f',3);
textLabelDesviacion->setText(i18n("Standard deviation: ")+s);

s = s.number(myTest->getParam_Asim(sociometricParam),'f',3);
textLabelAsimetria->setText(i18n("Asymmetry: ")+s);

s = s.number(myTest->getLimSup(sociometricParam),'f',3);
textLabelLimiteSuperior->setText(i18n("Top limit: ")+s);

s = s.number(myTest->getLimInf(sociometricParam),'f',3);
textLabelLimiteInferior->setText(i18n("Bottom limit: ")+s);


for (int c=1;c<=myTest->getNumeroAlumnosGrupo();c++)
{
// hay que vaciar las celdas antes de meter nuevos alumnos
table2->setText ( c-1, 0, QString::null );
table2->setText ( c-1, 1, QString::null );
table2->setText ( c-1, 2, QString::null );

    if (myTest->getSociometricValue(sociometricParam, c) > myTest->getLimSup(sociometricParam)) 
        table2->setText ( c-1, 0, myTest->getNombreAlumno(c) );
    else if (myTest->getSociometricValue(sociometricParam, c) < myTest->getLimInf(sociometricParam))
        table2->setText ( c-1, 2, myTest->getNombreAlumno(c) );
    else
        table2->setText ( c-1, 1, myTest->getNombreAlumno(c) );
}




}






void ksociograma::slotIndividualSociometricValueSelected(int idStudent)
{
QString s;

//valores sociometrico directos
textLabelSpValue->setText(s.number(myTest->getSp(idStudent+1),'f',0));
textLabelSpvValue->setText(s.number(myTest->getSpv(idStudent+1),'f',0));
textLabelSnValue->setText(s.number(myTest->getSn(idStudent+1),'f',0));
textLabelSnvValue->setText(s.number(myTest->getSnv(idStudent+1),'f',0));
textLabelEpValue->setText(s.number(myTest->getEp(idStudent+1),'f',0));
textLabelEnValue->setText(s.number(myTest->getEn(idStudent+1),'f',0));
textLabelRpValue->setText(s.number(myTest->getRp(idStudent+1),'f',0));
textLabelRpvValue->setText(s.number(myTest->getRpv(idStudent+1),'f',0));
textLabelRnValue->setText(s.number(myTest->getRn(idStudent+1),'f',0));
textLabelRnvValue->setText(s.number(myTest->getRnv(idStudent+1),'f',0));
textLabelOSValue->setText(s.number(myTest->getOS(idStudent+1),'f',0));
textLabelPpValue->setText(s.number(myTest->getPp(idStudent+1),'f',0));
textLabelPnValue->setText(s.number(myTest->getPn(idStudent+1),'f',0));
textLabelPApValue->setText(s.number(myTest->getPAp(idStudent+1),'f',0));
textLabelPAnValue->setText(s.number(myTest->getPAn(idStudent+1),'f',0));
textLabelIpValue->setText(s.number(myTest->getIp(idStudent+1),'f',0));
textLabelInValue->setText(s.number(myTest->getIn(idStudent+1),'f',0));
textLabelFPValue->setText(s.number(myTest->getFP(idStudent+1),'f',0));

//indices sociometricos
textLabelPopValue->setText(s.number(myTest->getPop(idStudent+1),'f',3));
textLabelAntValue->setText(s.number(myTest->getAnt(idStudent+1),'f',3));
textLabelExppValue->setText(s.number(myTest->getExpp(idStudent+1),'f',3));
textLabelExpnValue->setText(s.number(myTest->getExpn(idStudent+1),'f',3));
textLabelCAValue->setText(s.number(myTest->getCA(idStudent+1),'f',3));
textLabelAPValue->setText(s.number(myTest->getAP(idStudent+1),'f',3));
textLabelRPERValue->setText(s.number(myTest->getRPER(idStudent+1),'f',3));
textLabelSSValue->setText(s.number(myTest->getSS(idStudent+1),'f',3));


// tipos sociometricos
if (myTest->getSp(idStudent+1) >= myTest->getLimSup("Sp"))
    {
    textLabelTipoPopular->setEnabled(TRUE);
    textLabelTipoPopularEstrella->setEnabled(TRUE);
    }
    else
    {
    textLabelTipoPopular->setEnabled(FALSE);
    textLabelTipoPopularEstrella->setEnabled(FALSE);
    };

if (myTest->getSp(idStudent+1) <= myTest->getLimInf("Sp"))
    {
    textLabelTipoOlvidado->setEnabled(TRUE);
    }
    else
    {
    textLabelTipoOlvidado->setEnabled(FALSE);
    };

if (myTest->getSn(idStudent+1) >= myTest->getLimSup("Sn"))
    {
    textLabelTipoRechazado->setEnabled(TRUE);
    }
    else
    {
    textLabelTipoRechazado->setEnabled(FALSE);
    };



if ((myTest->getSp(idStudent+1) <= myTest->getLimInf("Sn")) and (myTest->getEp(idStudent+1) >= myTest->getLimSup("Ep")))
    {
    textLabelTipoOlvidadoDesatendido->setEnabled(TRUE);
    }
    else
    {
    textLabelTipoOlvidadoDesatendido->setEnabled(FALSE);
    };


if ((myTest->getSp(idStudent+1) <= myTest->getLimInf("Sp")) and (myTest->getEp(idStudent+1) <= myTest->getLimInf("Ep")))
    {
    textLabelTipoOlvidadoAislado->setEnabled(TRUE);
    }
    else
    {
    textLabelTipoOlvidadoAislado->setEnabled(FALSE);
    };


if ((myTest->getSp(idStudent+1) <= myTest->getLimInf("Sp")) and (myTest->getEp(idStudent+1) < myTest->getLimSup("Ep")) and (myTest->getEp(idStudent+1) > myTest->getLimInf("Ep")))
    {
    textLabelTipoOlvidadoIgnorado->setEnabled(TRUE);
    }
    else
    {
    textLabelTipoOlvidadoIgnorado->setEnabled(FALSE);
    };



}





 



// se selecciona un tipo de sociograma de grupo para mostrarse
void ksociograma::slotGroupSociogramSelected(int value)
{
/*
typeSociogram puede valer:
strongElection
weakElection
strongRejection
weakRejection
reciprocalElection
reciprocalRejection
reciprocalElectionAndRejection
*/

QString typeSociogram;

switch(comboBox1TabPage8->currentItem()) 
{ 
   case 0: typeSociogram="strongElection";break;
   case 1: typeSociogram="weakElection";break;
   case 2: typeSociogram="strongRejection";break;
   case 3: typeSociogram="weakRejection";break;
   case 4: typeSociogram="reciprocalElection";break;
   case 5: typeSociogram="reciprocalRejection";break;
   case 6: typeSociogram="reciprocalElectionAndRejection";break;
   default: typeSociogram = QString::null; 
}

myTest->setSociogramShow(typeSociogram);



//es importante desactivar y activar el comboBox1TabPage8 
//durante el repaint()
//para que el usuario no intente crear ms de 1 sociograma a la vez
//ya que aparecen errores grficos
comboBox1TabPage8->setEnabled(FALSE);
//groupSociogram->update(); //realiza un evento paint
groupSociogram->repaint(); //realiza un evento paint inmediatamente
comboBox1TabPage8->setEnabled(TRUE);



//TODO aqu hago como si se hubiera calculado el sociograma de grupo por primera vez, y cambio del valor de actSave, aunque es incorrecto, porque puede haberse realizado anteriormente. FIXME
myTest->isChangedTest=TRUE;
actSave->setEnabled(TRUE);

}













void ksociograma::slotDoAbbreviation(const QString &stringChanged)
{

QString tmp;
QString tmp2;


// trabajamos sobre una variable temporal
tmp = stringChanged;
// correccin de los datos de entrada
// quitamos lo que no sea letra, numero o _ del principio
tmp.replace( QRegExp("^\\W"), "" );
// quitamos los dobles espacios  por un solo espacio
tmp.replace( QRegExp("  "), " " );


// pone el nombre en mayusculas
tmp = tmp.upper();
	      
    QRegExp rx( "\\s(\\w)" );
    int pos = 0;
    while ( pos >= 0 ) {
        pos = rx.search( tmp, pos );
        if ( pos > -1 ) {
            tmp2 += rx.cap( 1 );
            pos  += rx.matchedLength();
        }
    }	      
	      
// introduce el nombre de usuario formateado y en mayusculas en el lineEdit
lineEdit9->setText(tmp);

// coje el primer caracter del nombre del alumno y lo introduce en el identificativo
lineEdit11->setText( tmp.left( 1 ) );

// coje el segundo o/y tercer o/y cuarto ... caracter del nombre del alumno y lo introduce en el identificativo, pero acorta el tmp2 a solo 2 caracteres
lineEdit11->setText( tmp.left( 1 )+tmp2.left(2) );


}







void ksociograma::closeAplication ( QCloseEvent * event )
{
// TODO hay que comprobar primero que tenemos un nombre y ruta para poder grabar el test, o en caso contrario no podremos grabarlo correctamente
    if ( myTest->isChangedTest and myTest->modeAccess==0) 
    { // the test has been changed
        switch ( QMessageBox::warning( this, "ksociograma",
                                        i18n("Your are going to quit the program. If you don't save the actual test data, they lose.\nDo you want to save the changed test?"),
                                        i18n("&Yes"),
                                        i18n("&No"),
                                        i18n("Cancel"),
                                        0, 2) ) {
        case 0: // yes
            //if ( save() )
            if (saveTest())
                event->accept();
            else
                event->ignore();
            break;
        case 1: // no
            event->accept();
            break;
        default: // cancel
            event->ignore();
            break;
        }
    }
    else
    {
    event->accept();
    }
}









/*!
    \fn ksociograma::slotQuestionnaireClosed()
 */
void ksociograma::questionnaireClosed()
{

if (myTest->numberStudentsEvaluated()==myTest->getNumeroAlumnosGrupo() and myTest->getNumeroAlumnosGrupo()>0 and myTest->modeAccess==0 ) 
   {
   QMessageBox::information( this, "ksociograma",
         i18n("All the forms have been completed.\nAll the analysis tabs have been enabled."));
   }
   
 //necesita actualizar la tabla de estudiantes con los datos que vienen del cuestionario   
showStudentsTableData();
disableWidgets();
setTasksAndPages();

//al cerrar en modo cuestionarios, hay que dar la posibilidad de comenzar otro test
if (myTest->modeAccess==1)
{
newTest();
newAccess();
disableWidgets();
setTasksAndPages();
}

}








/*!
    rellanamos el tabPage1
 */
void ksociograma::showGeneralTestData()
{
        // 
        textLabel20->setText(i18n("This page is designed so that you introduce the general performances of the new sociometric test that is going to make."));
        radioButton1->setChecked (myTest->getCriterioPsicotelico());
        radioButton2->setChecked (myTest->getCriterioSociotelico());
        radioButton3->setChecked (myTest->getCriterioAutoridad());
        ///radioButtonXXX->checked (myTest->getCriterioAfinidad());
        radioButton10->setChecked (myTest->getCriterioPropio());
        if (myTest->getNumeroElecciones()==3) radioButton4->setChecked(TRUE);
        if (myTest->getNumeroElecciones()==5) radioButton5->setChecked(TRUE);
        if (myTest->getNumeroElecciones()==-1) radioButton6->setChecked(TRUE); 
        // para el caso de que vengamos de un test nuevo
        if (myTest->getNumeroElecciones()==0) 
            {
            radioButton4->setChecked(FALSE);
            radioButton5->setChecked(FALSE);
            radioButton6->setChecked(FALSE);
            }
        
        if (myTest->getCriterioPropio()) 
            {
            // esta pulsado el criteriopropio
            lineEdit12->setText(myTest->getQuestion1());
            lineEdit13->setText(myTest->getQuestion2());
            lineEdit14->setText(myTest->getQuestion3());
            lineEdit15->setText(myTest->getQuestion4());
            }
        else if (myTest->getCriterioPsicotelico() or
                 myTest->getCriterioSociotelico() or
                 myTest->getCriterioAutoridad() or
                 myTest->getCriterioAfinidad())
            {
            // est pulsado un criterio que no es el propio
            // y, aunque no estan habilitados los items propio,
            // se converva su texto por si fuera necesario
            lineEdit12->setText(lineEdit12->text());
            lineEdit13->setText(lineEdit13->text());
            lineEdit14->setText(lineEdit14->text());
            lineEdit15->setText(lineEdit15->text());            
            }
        else
            {
            // para cuando se pulsa sobre un test nuevo y
            // no cambia a vacio los items propios a pesar
            // de estar vacios en myTest, debido
            // a que no se tiene pulsado el radioButton del criterio propio
            // (en un test nuevo no hay pulsados ningun radioButton)
            lineEdit12->setText(QString::null);
            lineEdit13->setText(QString::null);
            lineEdit14->setText(QString::null);
            lineEdit15->setText(QString::null);
            }
            
}


/*!
    rellanamos el tabPage2
 */
void ksociograma::showGeneralGroupData()
{
        // 
        textLabel21->setText(i18n("Complete here the general performances of the group of students who are going to make the test."));
        lineEdit3->setText(myTest->getNombreInstitucion());
        lineEdit4->setText(myTest->getNombreTutor());
        lineEdit5->setText(myTest->getDescripcionGrupo());
        lineEdit6->setText(myTest->getIdentificativoGrupo());
        spinBox1->setValue(myTest->getNumeroAlumnosGrupo());

}


/*!
    rellanamos el tabPage3
 */
void ksociograma::showStudentsTableData()
{
        textLabel22->setText(i18n("Creating the students data base. It's very important that you complete it, at least, with the name of each student. The student identification is generated automatically from the name initials that you have written. Push the button 'Append/Edit'. This will cause that it happens to the matrix of data that appears just underneath, remaining in the electronic memory of computer. Too, clicking mouse into data matrix, you can edit a student."));
        QString s;
        // borramos los campos de introduccin de datos
        lineEdit8->setText( QString::null);
        lineEdit9->setText( QString::null);
        radioButton7->setChecked(FALSE);
        radioButton8->setChecked(FALSE);
        radioButton9->setChecked(TRUE);
        spinBox2->setValue(5);
        lineEdit11->setText( QString::null);
       
        // Initial values for students table
        table1->setNumCols( 4 );
        table1->setColumnWidth( 0, 510 ); 
        table1->setColumnWidth( 1, 70 );
        table1->setColumnWidth( 2, 150 );
        table1->setColumnWidth( 3, 150 );
        QHeader *th1 = table1->horizontalHeader();
        th1->setLabel( 0, i18n("Name") );
        th1->setLabel( 1, i18n("Years old") );
        th1->setLabel( 2, i18n("Gender") );
        th1->setLabel( 3, i18n("Identification") );

        
        // rellenamos la tabla con la base de datos de alumnos
        table1->setNumRows(myTest->getNumeroAlumnosGrupo());
        
            for (int row=0;row<=(myTest->getNumeroAlumnosGrupo()-1);row++)
            {
            table1->setText(row,0,myTest->getNombreAlumno(row+1));
            s = s.setNum(myTest->getEdadAlumno(row+1));
            table1->setText(row,1,s);
            if (myTest->getSexoAlumno(row+1)=="Hombre") table1->setText(row,2,i18n("Male"));
            if (myTest->getSexoAlumno(row+1)=="Mujer") table1->setText(row,2,i18n("Female"));
            if (myTest->getSexoAlumno(row+1)==QString::null) table1->setText(row,2,QString::null);
            table1->setText(row,3,myTest->getIdentificativoAlumno(row+1));
            }
        
  
          
                   
            
 
}


/*!
    rellenamos el tabPage4
 */
void ksociograma::showSignificantValues()
{
        textLabel23->setText(i18n("")); //TODO texto ayuda 
        
        
        // Initial values for significant values table
        table2->setNumCols( 3 );
        table2->setColumnWidth( 0, 280 ); 
        table2->setColumnWidth( 1, 280 );
        table2->setColumnWidth( 2, 280 );
        QHeader *th2 = table2->horizontalHeader();
        th2->setLabel( 0, i18n("High and significant sociometric values") );
        th2->setLabel( 1, i18n("No significant sociometric values") );
        th2->setLabel( 2, i18n("Low and significant sociometric values") );
        //table2->setNumRows(0);        
        
        
        
        
        table2->setNumRows(myTest->getNumeroAlumnosGrupo());
        //Initial values for sociometric types in tabPage3
        comboBox1->clear(); //importante para no acumular items
        comboBox1->insertItem ( i18n("Status of elections (Sp)"), 0 );
        comboBox1->insertItem ( i18n("Status of rejections (Sn)"), 1 );
        comboBox1->insertItem ( i18n("Positive expansion (Ep)"), 2 );
        comboBox1->insertItem ( i18n("Negative expansion (En)"), 3 );
        comboBox1->insertItem ( i18n("Perception of elections (Pp)"), 4 );
        comboBox1->insertItem ( i18n("Perception of rejections (Pn)"), 5 );
        comboBox1->insertItem ( i18n("Sensation of elections (Ip)"), 6 );
        comboBox1->insertItem ( i18n("Sensation of rejections (In)"), 7 );
        

}


/*!
    rellenamos el tabPage 5
 */
void ksociograma::showIndividualIndexsAndValues()
{
        textLabel24->setText(i18n(""));
        // alumnos para el comboBox2 
        comboBox2->clear(); //importante para no acumular items repetidos
        for (int c=1; c<=myTest->getNumeroAlumnosGrupo();c++)
        {
          comboBox2->insertItem ( myTest->getNombreAlumno(c), c-1 );
        }
}


/*!
     rellena el tabPage 6
 */
void ksociograma::showGroupIndexs()
{
         textLabel25->setText(i18n(""));
         //indices sociometricos del grupo
         QString s;
         textLabelIAValue->setText(s.number(myTest->getGIA(),'f',3));   
         textLabelIDValue->setText(s.number(myTest->getGID(),'f',3));   
         textLabelICValue->setText(s.number(myTest->getGIC(),'f',3));   
         textLabelISValue->setText(s.number(myTest->getGIS(),'f',3));   
         textLabelPS1Value->setText(s.number(myTest->getGPS("Hombre"),'f',3));
         textLabelPS2Value->setText(s.number(myTest->getGPS("Mujer"),'f',3));   
}


/*!
    rellenamos el tabPage 7
 */
void ksociograma::showIndividualSociograms()
{
            //insertamos los alumnos en el comboBox1TabPage6
            comboBox1TabPage7->clear(); //importante para no acumular items
            for (int row=0;row<=(myTest->getNumeroAlumnosGrupo()-1);row++)
            {
            comboBox1TabPage7->insertItem ( myTest->getNombreAlumno(row+1),row);
            }

}


/*!
    rellenamos el tabPage 8
 */
void ksociograma::showGroupSociograms()
{
        //insertamos los tipos de sociograma de grupo  en el comboBox1TabPage7
            comboBox1TabPage8->clear(); //importante para no acumular items
            comboBox1TabPage8->insertItem ( i18n("Strong elections"),0);
            comboBox1TabPage8->insertItem ( i18n("Weak elections"),1);
            comboBox1TabPage8->insertItem ( i18n("Strong rejections"),2);
            comboBox1TabPage8->insertItem ( i18n("Weak rejections"),3);
            comboBox1TabPage8->insertItem ( i18n("Reciprocal elections"),4);
            comboBox1TabPage8->insertItem ( i18n("Reciprocal rejections"),5);
            comboBox1TabPage8->insertItem ( i18n("Reciprocal elections and rejections"),6);

}


















/*!
    \fn ksociograma::newTest()
 */
void ksociograma::newTest()
{
if (!myTest->isChangedTest)
    {
    myTest->newTest();
    tabWidget1->setCurrentPage ( 0 );
    setTasksAndPages();
    disableWidgets(); 
    actSave->setEnabled(FALSE);
    actPrint->setEnabled(FALSE);
    }
else if (myTest->modeAccess==0)
    {
        switch ( QMessageBox::warning( this, "ksociograma",
                                        i18n("Do you want to save the data before creating a new test?"),
                                        i18n("&Yes"),
                                        i18n("&No"),
                                        i18n("Cancel"),
                                        0, 2) ) {
        case 0: // yes
            saveTest();
            myTest->isChangedTest=FALSE;
            actSave->setEnabled(FALSE);
	    actPrint->setEnabled(FALSE);
            newTest(); // se vuelve a llamar a la funcin
            break;
        case 1: // no
            myTest->isChangedTest=FALSE;
            actSave->setEnabled(FALSE);
	    actPrint->setEnabled(FALSE);
            newTest(); // se vuelve a llamar a la funcin
            break;
        default: // cancel
            break;
        }
    }
}


/*!
    graba todo los datos del test en disco
 */
bool ksociograma::saveTest()
{
QString sURL=QString::null;

// sin no se ha definido aun la ruta para grabar el test, sacar el dialogo
if (myTest->getRutaFicheroTest()==QString::null)
{
    KFileDialog* fd = new KFileDialog( QString::null,"*",this,0,TRUE,0 );
    fd->show();	
    if ( fd->exec() == KDialog::Accepted ) 
    {
        KURL myURL = fd->selectedURL();
        //QString sURL = myURL.prettyURL(); //si empieza en file:/ o ftp://
        sURL = myURL.path(); //no comienza en file:/ o ftp://
    }
    delete fd;

}
else
{
    sURL = myTest->getRutaFicheroTest();
}



//solo si se existe la ruta del fichero test se grabar y actualizara el objeto myTest
if (sURL!=QString::null)
{
	myTest->setRutaFicheroTest(sURL);
	myTest->GrabaDatosGeneralesTest (sURL);
	myTest->GrabaDatosGeneralesGrupo (sURL);
	myTest->GrabaBaseDatosAlumnos (sURL); 
	for (int c=1;c<=myTest->getNumeroAlumnosGrupo();c++) 
	{
	myTest->GrabaRespuestas (c, sURL);
	}
	myTest->savePosition("strongElection",sURL);
	myTest->savePosition("weakElection",sURL);
	myTest->savePosition("strongRejection",sURL);
	myTest->savePosition("weakRejection",sURL);
	myTest->savePosition("reciprocalElection",sURL);
	myTest->savePosition("reciprocalRejection",sURL);
	myTest->savePosition("reciprocalElectionAndRejection",sURL);
	myTest->saveTasks (sURL);   
	myTest->isChangedTest=FALSE;
	actSave->setEnabled(FALSE);
	return TRUE;
}
else
{
	return FALSE;
}

}


/*!
    \fn ksociograma::openQuestionnaire()
 */
void ksociograma::openQuestionnaire()
{
questionnaire *questionnaireWin = 0;
questionnaireWin = new questionnaire(0,0,0,myTest,this);
questionnaireWin->showMaximized();
}








/*!
    \fn ksociograma::slotChangeCriterion(int idRadioButton)
 */
void ksociograma::slotChangeCriterion(int idRadioButton)
{

//solo podemos cambiarlo si no se ha completado ningn cuestionario aun
//(deben estar deshabilitados en la carga del fichero o al realizar el 
// primer cuestionario)
   
    myTest->isChangedTest=TRUE; 
    actSave->setEnabled(TRUE);
    myTest->setCriterioPsicotelico( radioButton1->isChecked () );
    myTest->setCriterioSociotelico( radioButton2->isChecked () );
    myTest->setCriterioAutoridad( radioButton3->isChecked () );
    //myTest->setCriterioAfinidad( radioButtonXXXXXXX->isChecked () );
    myTest->setCriterioPropio( radioButton10->isChecked () );     
    setTasksAndPages();

}


/*!
    \fn ksociograma::slotChangeNumberElection(int idRadioButton)
 */
void ksociograma::slotChangeNumberElection(int idRadioButton)
{
//solo podemos cambiarlo si no se ha completado ningn cuestionario aun
//(deben estar deshabilitados en la carga del fichero o al realizar el 
// primer cuestionario)
   
   myTest->isChangedTest=TRUE; 
   actSave->setEnabled(TRUE);
   if (radioButton4->isChecked()) myTest->setNumeroElecciones( 3 ); 
   if (radioButton5->isChecked()) myTest->setNumeroElecciones( 5 );  
   if (radioButton6->isChecked()) myTest->setNumeroElecciones( -1 ); 
   setTasksAndPages();

}





/*!
    \fn ksociograma::slotChangeQuestion1(const QString &text)
 */
void ksociograma::slotChangeQuestion1(const QString &text)
{
    myTest->isChangedTest=TRUE; 
    actSave->setEnabled(TRUE);
    myTest->setQuestion1(text);
    setTasksAndPages();
}


/*!
    \fn ksociograma::slotChangeQuestion2(const QString &text)
 */
void ksociograma::slotChangeQuestion2(const QString &text)
{
    myTest->isChangedTest=TRUE; 
    actSave->setEnabled(TRUE);
    myTest->setQuestion2(text);
    setTasksAndPages();
}


/*!
    \fn ksociograma::slotChangeQuestion3(const QString &text)
 */
void ksociograma::slotChangeQuestion3(const QString &text)
{
    myTest->isChangedTest=TRUE; 
    actSave->setEnabled(TRUE);
    myTest->setQuestion3(text);
    setTasksAndPages();
}


/*!
    \fn ksociograma::slotChangeQuestion4(const QString &text)
 */
void ksociograma::slotChangeQuestion4(const QString &text)
{
    myTest->isChangedTest=TRUE; 
    actSave->setEnabled(TRUE);
    myTest->setQuestion4(text);
    setTasksAndPages();
}







/*!
    \fn ksociograma::slotChangeNameInstitution(const QString &nameInstitution)
 */
void ksociograma::slotChangeNameInstitution(const QString &nameInstitution)
{
    myTest->isChangedTest=TRUE; 
    actSave->setEnabled(TRUE);
    myTest->setNombreInstitucion(nameInstitution);
    setTasksAndPages();
}


/*!
    \fn ksociograma::slotChangeNameTeacher(const QString &nameTeacher)
 */
void ksociograma::slotChangeNameTeacher(const QString &nameTeacher)
{
    myTest->isChangedTest=TRUE; 
    actSave->setEnabled(TRUE);
    myTest->setNombreTutor(nameTeacher);
    setTasksAndPages();
}


/*!
    \fn ksociograma::slotChangeGroupDescription(const QString &groupDescription)
 */
void ksociograma::slotChangeGroupDescription(const QString &groupDescription)
{
    myTest->isChangedTest=TRUE; 
    actSave->setEnabled(TRUE);
    myTest->setDescripcionGrupo(groupDescription);
    setTasksAndPages();
}


/*!
    \fn ksociograma::slotChangeGroupId(const QString &groupId)
 */
void ksociograma::slotChangeGroupId(const QString &groupId)
{
    myTest->isChangedTest=TRUE; 
    actSave->setEnabled(TRUE);
    myTest->setIdentificativoGrupo(groupId);
    setTasksAndPages();
}


/*!
    \fn ksociograma::slotChangeNumberStudents(const QString &numberStudents)
 */
void ksociograma::slotChangeNumberStudents(const QString &numberStudents)
{
    myTest->isChangedTest=TRUE; 
    actSave->setEnabled(TRUE);
    myTest->setNumeroAlumnosGrupo(numberStudents.toInt());
    setTasksAndPages();
    if (myTest->numberStudentsInDataBase() < myTest->getNumeroAlumnosGrupo())
    actOpenQuestionnaire->setEnabled(FALSE);

}













/*!
   se averigua si algn alumno ha sido ya evaluado y entonces deshabilita los widget
   del test para que no puedan ser cambiados y el programa no cometa errores
 */

void ksociograma::disableWidgets()
{
        // si ya se ha evaluado al menos a un alumno
        // entonces hay que inhabilitar los campos
        // que no deben cambiar en el test
        if (myTest->numberStudentsEvaluated()>0) 
        { 
        // para los radiobutton del criterio
        radioButton1->setEnabled(FALSE);
        radioButton2->setEnabled(FALSE);
        radioButton3->setEnabled(FALSE);
        //radioButtonXXX->setEnabled(FALSE);
        radioButton10->setEnabled(FALSE);
        lineEdit12->setEnabled(FALSE);
        lineEdit13->setEnabled(FALSE);
        lineEdit14->setEnabled(FALSE);
        lineEdit15->setEnabled(FALSE);
        
        //para los radiobutton del numero de elecciones
        radioButton4->setEnabled(FALSE);
        radioButton5->setEnabled(FALSE);
        //radioButton6->setEnabled(FALSE);
        
        //para el numero de alumnos del grupo
        spinBox1->setEnabled(FALSE);
        
        //para la introduccion/modificacion de la DB de alumnos
        lineEdit9->setEnabled(FALSE);
        spinBox2->setEnabled(FALSE);
        radioButton7->setEnabled(FALSE);
        radioButton8->setEnabled(FALSE);
        radioButton9->setEnabled(FALSE);
        lineEdit11->setEnabled(FALSE);
        pushButton7->setEnabled(FALSE);
        
        }
	else
	{
        // para los radiobutton del criterio
        radioButton1->setEnabled(TRUE);
        radioButton2->setEnabled(TRUE);
        radioButton3->setEnabled(TRUE);
        //radioButtonXXX->setEnabled(TRUE);
        radioButton10->setEnabled(TRUE);
        
        // los cuatro lineEdit para la introduccin de las preguntas no se activan
        // ahora: se activaran cuando se active el radioButton10 del criterio propio
        //lineEdit12->setEnabled(TRUE);
        //lineEdit13->setEnabled(TRUE);
        //lineEdit14->setEnabled(TRUE);
        //lineEdit15->setEnabled(TRUE);
        
        //para los radiobutton del numero de elecciones
        radioButton4->setEnabled(TRUE);
        radioButton5->setEnabled(TRUE);
        //radioButton6->setEnabled(TRUE);
        
        //para el numero de alumnos del grupo
        spinBox1->setEnabled(TRUE);
        
        //para la introduccion/modificacion de la DB de alumnos
        lineEdit9->setEnabled(TRUE);
        spinBox2->setEnabled(TRUE);
        radioButton7->setEnabled(TRUE);
        radioButton8->setEnabled(TRUE);
        radioButton9->setEnabled(TRUE);
        lineEdit11->setEnabled(TRUE);
        pushButton7->setEnabled(TRUE);
	
	}
}



/*!
    ajusta las tareas terminadas y hace visibles los tabPages correspondientes
    ademas, cuando se hace visible un nuevo tabPage se genera su contenido
    a travs de la funcion showXXXX
 */
void ksociograma::setTasksAndPages()
{

//antes de efectual cambio guardo el tabPage activo
int activeTabPage = tabWidget1->currentPageIndex ( );

if (myTest->modeAccess==-1 or myTest->modeAccess==1) //no hay modo de acceso definido o se entra como sujeto que realiza cuestionarios
{
tabWidget1->setTabEnabled ( TabPage0, TRUE );
tabWidget1->setTabEnabled ( TabPage1, FALSE );
tabWidget1->setTabEnabled ( TabPage2, FALSE );
tabWidget1->setTabEnabled ( TabPage3, FALSE );
tabWidget1->setTabEnabled ( TabPage4, FALSE );
tabWidget1->setTabEnabled ( TabPage5, FALSE );
tabWidget1->setTabEnabled ( TabPage6, FALSE );
tabWidget1->setTabEnabled ( TabPage7, FALSE );
tabWidget1->setTabEnabled ( TabPage8, FALSE );
activeTabPage=0;
return;
}







// activacion de tarea1 si tab1 terminado
if (myTest->modeAccess==0 and
    ( myTest->getCriterioSociotelico()==TRUE or
      myTest->getCriterioPsicotelico()==TRUE or
      myTest->getCriterioAutoridad()==TRUE or
      myTest->getCriterioPropio()==TRUE ) and
    ( myTest->getCriterioPropio()==FALSE or
      ( myTest->getQuestion1().length ()>0 and
        myTest->getQuestion2().length ()>0 and
        myTest->getQuestion3().length ()>0 and
        myTest->getQuestion4().length ()>0)) and
    myTest->getNumeroElecciones()>0 )
{
if (myTest->getTarea1()==FALSE)
    myTest->setTarea1(TRUE); myTest->isChangedTest=TRUE;
}






// activacion de tarea2 si tab2 terminado
if (myTest->modeAccess==0 and
    myTest->getNombreInstitucion().length()>0 and
    myTest->getNombreTutor().length()>0 and
    myTest->getDescripcionGrupo().length()>0 and
    myTest->getIdentificativoGrupo().length()>0 and
    myTest->getNumeroAlumnosGrupo()>=5) // no se permiten test con menos de 5 alumnos
{
if (myTest->getTarea2()==FALSE)
    myTest->setTarea2(TRUE); myTest->isChangedTest=TRUE;
}







// activacion de tarea3 si tab3 terminado
if (myTest->modeAccess==0 and
myTest->numberStudentsInDataBase()==myTest->getNumeroAlumnosGrupo() and myTest->getNumeroAlumnosGrupo()>=5)
{
if (myTest->getTarea3()==FALSE)
    myTest->setTarea3(TRUE); myTest->isChangedTest=TRUE;
}





// activacion de tarea4 si cuestionarios terminados
if (myTest->modeAccess==0 and myTest->numberStudentsEvaluated()==myTest->getNumeroAlumnosGrupo() and myTest->getNumeroAlumnosGrupo()>=5)
{
if (myTest->getTarea1()==FALSE)
    myTest->setTarea4(TRUE); myTest->isChangedTest=TRUE;
}



































//despues de haber actualizado el estado de los flags tareas
//si realiza el acceso como administrador y se activan las pestaas
//dependiendo de las tareas terminadas.
//adems se muestra el contenido del tab activado mediante la funcion showXXX
if (myTest->modeAccess==0)
{
//una vez accedido como administrador nunca aparece el tab de acceso
tabWidget1->setTabEnabled ( TabPage0, FALSE );

//una vez accedido como administrador siempre aparece el tab1: datos generales del test
tabWidget1->setTabEnabled ( TabPage1, TRUE );
showGeneralTestData();
if (activeTabPage==0) activeTabPage=1;; 


//si tarea1=concluidos datos generales test
//entonces se activa tab2=datos del grupo
if (myTest->getTarea1()==TRUE)
    {tabWidget1->setTabEnabled ( TabPage2, TRUE ); showGeneralGroupData();}
else
    tabWidget1->setTabEnabled ( TabPage2, FALSE );

//si tarea2=concluidos datos del grupo
//entonces se activa tab3=tabla alumnado
if (myTest->getTarea2()==TRUE)
    {tabWidget1->setTabEnabled ( TabPage3, TRUE ); showStudentsTableData();}
else
    tabWidget1->setTabEnabled ( TabPage3, FALSE );

//si tarea3=concluida tabla de alumnado
//entonces se activa el menu para cuestionarios
if (myTest->getTarea3()==TRUE)
    actOpenQuestionnaire->setEnabled(TRUE);
else
    actOpenQuestionnaire->setEnabled(FALSE);


//si tarea4=conclidos todos los cuestionarios
//entonces se activan todo el resto de pestaas
if (myTest->getTarea4()==TRUE)
    {
    tabWidget1->setTabEnabled ( TabPage4, TRUE );
    tabWidget1->setTabEnabled ( TabPage5, TRUE );
    tabWidget1->setTabEnabled ( TabPage6, TRUE );
    tabWidget1->setTabEnabled ( TabPage7, TRUE );
    tabWidget1->setTabEnabled ( TabPage8, TRUE );
    showSignificantValues();
    showIndividualIndexsAndValues();
    showGroupIndexs();
    showIndividualSociograms();
    individualSociogram->update();
    showGroupSociograms();
    groupSociogram->update();
    actPrint->setEnabled(TRUE);
    }
else
    {
    tabWidget1->setTabEnabled ( TabPage4, FALSE );
    tabWidget1->setTabEnabled ( TabPage5, FALSE );
    tabWidget1->setTabEnabled ( TabPage6, FALSE );
    tabWidget1->setTabEnabled ( TabPage7, FALSE );
    tabWidget1->setTabEnabled ( TabPage8, FALSE );
    }

}




//antes de salir, vuelvo a poner el tabPage que estaba activo
tabWidget1->setCurrentPage ( activeTabPage ); 


}






/*!
    saca por impresora o archivo el test completo
 */
void ksociograma::printTest()
{
/*
typeSociogram puede valer:
strongElection
weakElection
strongRejection
weakRejection
reciprocalElection
reciprocalRejection
reciprocalElectionAndRejection
*/

if (myTest->getTarea("strongElection") and
    myTest->getTarea("weakElection") and
    myTest->getTarea("strongRejection") and
    myTest->getTarea("weakRejection") and
    myTest->getTarea("reciprocalElection") and
    myTest->getTarea("reciprocalRejection") and
    myTest->getTarea("reciprocalElectionAndRejection"))
    {   
    
    printAllIndividualSociogram();
    printAllGroupSociogram();
    
    }
else
    {
    QMessageBox::critical( this, "KSociograma",
    i18n("It's no possible to print: you have not make all the group sociogram yet.\n\nPlease, go to 'Group sociogram' tab and make each type that sets out you.") );    
    }


}








/*!
    control de acceso al programa
 */
void ksociograma::slotAccess()
{
    // para el administrador
    if (radioButton11->isChecked() and lineEdit16->text()=="admin" and lineEdit17->text()=="ksocio")
       {
       //TODO posibilitar el cambio de claves a travs de un fichero en ~/.ksociograma con clave encriptada
       myTest->modeAccess=0; //0=modo administrador
       setTasksAndPages();
       
       actOpenNew->setEnabled(TRUE);
       actOpen->setEnabled(TRUE);
       actSave->setEnabled(FALSE);
       actPrint->setEnabled(FALSE);
       actOpenQuestionnaire->setEnabled(FALSE);
 
       
       
       
       
       }
    // para el sujeto
    else if (radioButton12->isChecked() and !kURLRequester1->url().isEmpty())
       {
       // TODO hay que comprobar que se es un fichero de test sociometrico correcto antes de pasar
       myTest->modeAccess=1; //1=modo cuestionarios
       
       //TODO no pudo coger ficheros de la red con ->url() y 
       //KURL myURL = kURLRequester1->selectedURL(); no funciona que es la buena
       KURL myURL = kURLRequester1->url(); 
       //QString sURL = myURL.prettyURL(); //si empieza en file:/ o ftp://
       QString sURL = myURL.path(); //no comienza en file:/ o ftp://
       
       myTest->CargaDatosGeneralesTest (sURL);
       myTest->CargaDatosGeneralesGrupo (sURL);
       myTest->CargaBaseDatosAlumnos (sURL);
       myTest->CargaRespuestas (sURL);
       myTest->loadPosition(sURL);
       
       //guardamos la localizacion del test
       myTest->setRutaFicheroTest(sURL);

       disableWidgets();
       setTasksAndPages();
       
       //desabilitamos el test en modo administrador 
       actOpen->setEnabled(FALSE);
       actOpenNew->setEnabled(FALSE);
       actSave->setEnabled(FALSE);
       actPrint->setEnabled(FALSE);
       actOpenNew->setEnabled(FALSE);
       actOpenQuestionnaire->setEnabled(FALSE);
       
       openQuestionnaire();


       
     } 
       

    // en otro caso no se permite el acceso
    else 
       {
       newAccess();
       }
     
}


/*!
    Intercepta y actua cuando clickamos sobre un modo de acceso u otro (administrador o sujeto)
 */
void ksociograma::slotChangeModeAccess(int modeAccess)
{
    if (modeAccess==0) 
    {
    lineEdit16->setEnabled(TRUE);
    lineEdit17->setEnabled(TRUE);
    kURLRequester1->setEnabled(FALSE);
    pushButton3->setEnabled(TRUE);
    }
    else if (modeAccess==1)
    {
    lineEdit16->setEnabled(FALSE);
    lineEdit17->setEnabled(FALSE);
    kURLRequester1->setEnabled(TRUE);
    pushButton3->setEnabled(TRUE);
    }
    else
    {
    //newAccess();
    }
    
}


/*!
    \fn ksociograma::newAccess()
 */
void ksociograma::newAccess()
{
       myTest->modeAccess=-1; //-1: no hay acceso
       lineEdit16->setEnabled(FALSE);
       lineEdit17->setEnabled(FALSE);
       kURLRequester1->setEnabled(FALSE);
       pushButton3->setEnabled(FALSE);   
       radioButton11->setChecked(FALSE);
       radioButton12->setChecked(FALSE);
       lineEdit16->setText(QString::null);
       lineEdit17->setText(QString::null);
       
       actOpenNew->setEnabled(FALSE);
       actOpen->setEnabled(FALSE);
       actSave->setEnabled(FALSE);
       actPrint->setEnabled(FALSE);
       actOpenQuestionnaire->setEnabled(FALSE);
}


/*!
    Imprime todos los sociogramas individuales
 */
void ksociograma::printAllIndividualSociogram()
{
KPrinter *myPrinter = new KPrinter(TRUE, QPrinter::ScreenResolution);
// do some printer initialization
//myPrinter->setPageSize ( KPrinter::A4 );
myPrinter->setOrientation ( KPrinter::Landscape );
myPrinter->setOutputToFile ( TRUE );
myPrinter->setOutputFileName ( "~/Individuals_Sociograms.pdf" ); 

   
   // initialize the printer using the print dialog
   if ( myPrinter->setup( this ))
   {    
    myPainterSociogramIndividual->end();
     // start painting
    //if (!myPainter.begin( myPrinter )) return;
    myPainterSociogramIndividual->begin( myPrinter );


//-------------------------------------------------------------
// imprimir todos los sociogramas individuales

for (int c=1;c<=myTest->getNumeroAlumnosGrupo();c++)
    {
    comboBox1TabPage7->setCurrentItem ( c-1 );
    myTest->setStudentShow(comboBox1TabPage7->currentItem ()+1);
    individualSociogram->update(); //realiza un evento paint
    individualSociogram->drawTitle(individualSociogram->width()-(individualSociogram->width()-individualSociogram->height())+15,15, myTest->getNombreAlumno(c));
    individualSociogram->drawIndividualSociogram( myTest, 0, 0);
    individualSociogram->drawMeaning(QRect (QPoint(individualSociogram->width()-(individualSociogram->width()-individualSociogram->height())+15,qRound(individualSociogram->height()/1.5)),QPoint(individualSociogram->width()-15,individualSociogram->height()-15))); // el +/-15 es para que no quede pegado al borde
    individualSociogram->drawSociometricValueSignificant (QRect (QPoint(individualSociogram->width()-(individualSociogram->width()-individualSociogram->height())+15,qRound(individualSociogram->height()/4)),QPoint(individualSociogram->width()-15,qRound(individualSociogram->height()/1.8))));
    myPrinter->newPage();
    
    }
    
    
    
     // stop painting, this will automatically send the print data to the printer
    myPainterSociogramIndividual->end();
   }
delete myPrinter;
    
//-------------------------------------------------------------

}


/*!
    Imprime todos los sociogramas de grupo
 */
void ksociograma::printAllGroupSociogram()
{
KPrinter *myPrinter = new KPrinter(TRUE, QPrinter::ScreenResolution);

// do some printer initialization
//myPrinter->setPageSize ( KPrinter::A4 );
myPrinter->setOrientation ( KPrinter::Landscape );
myPrinter->setOutputToFile ( TRUE );
myPrinter->setOutputFileName ( "~/Group_Sociograms.pdf" ); 
   
   // initialize the printer using the print dialog
   if ( myPrinter->setup( this ))
   {     
    myPainterSociogramGroup->end();
    // start painting
    //if (!myPainter.begin( myPrinter )) return;
    myPainterSociogramGroup->begin( myPrinter );
    
    //-------------------------------------------------------------
    // imprimir todos los sociogramas grupo
    QString typeSociogram;
    for (int c=0;c<=6;c++)
    {
    if (c==0) typeSociogram="strongElection"; 
    if (c==1) typeSociogram="weakElection";
    if (c==2) typeSociogram="strongRejection";
    if (c==3) typeSociogram="weakRejection";
    if (c==4) typeSociogram="reciprocalElection";
    if (c==5) typeSociogram="reciprocalRejection";
    if (c==6) typeSociogram="reciprocalElectionAndRejection";
    
    
    comboBox1TabPage8->setCurrentItem ( c );
    myTest->setSociogramShow(typeSociogram);
    groupSociogram->update(); //realiza un evento paint
    
    if (c==0) groupSociogram->drawTitle(groupSociogram->width()-(groupSociogram->width()-groupSociogram->height())+15,15, i18n("Strong Elections Sociogram"));
    
    if (c==1) groupSociogram->drawTitle(groupSociogram->width()-(groupSociogram->width()-groupSociogram->height())+15,15, i18n("Weak Elections Sociogram"));
    
    if (c==2) groupSociogram->drawTitle(groupSociogram->width()-(groupSociogram->width()-groupSociogram->height())+15,15, i18n("Strong Rejections Sociogram"));
    
    if (c==3) groupSociogram->drawTitle(groupSociogram->width()-(groupSociogram->width()-groupSociogram->height())+15,15, i18n("Weak Rejections Sociogram"));
    
    if (c==4) groupSociogram->drawTitle(groupSociogram->width()-(groupSociogram->width()-groupSociogram->height())+15,15, i18n("Reciprocal Elections Sociogram"));
    
    if (c==5) groupSociogram->drawTitle(groupSociogram->width()-(groupSociogram->width()-groupSociogram->height())+15,15, i18n("Reciprocal Rejections Sociogram"));
    
    if (c==6) groupSociogram->drawTitle(groupSociogram->width()-(groupSociogram->width()-groupSociogram->height())+15,15, i18n("Reciprocal Elections and Rejections Sociogram"));

    groupSociogram->drawGroupSociogram( myTest, 0, 0);
    groupSociogram->drawMeaning(QRect (QPoint(groupSociogram->width()-(groupSociogram->width()-groupSociogram->height())+15,qRound(groupSociogram->height()/1.5)),QPoint(groupSociogram->width()-15,groupSociogram->height()-15))); // el +/-15 es para que no quede pequdo al borde
    myPrinter->newPage();
    }    
     // stop painting, this will automatically send the print data to the printer
    myPainterSociogramGroup->end();
   }
delete myPrinter;
    
//-------------------------------------------------------------

}
