/***************************************************************************
 *   Copyright (C) 2004 by Manuel Prez Lpez                              *
 *   mapelo@ieduca.net http://www.ieduca.net/                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef SOCIOGRAM_H
#define SOCIOGRAM_H

#include <qwidget.h>
#include <qdatetime.h>
#include "sociometrictest.h"
#include <qcombobox.h>
//#include <qpointarray.h>

/**
Class for create a graphics sociogram.

@author Manuel Prez Lpez
*/
class sociogram : public QWidget
{
Q_OBJECT
public:
    sociogram( QWidget *parent2=0, const char *name2 = 0 , QPainter *myPainter2 = 0, sociometricTest *myTest2 = 0);
    ~sociogram();


    void initialValues();
    void setRelativeFirstZone(int value);
    double rotateAngle(QString sex, int zone, double angle, int giro);
    int rotateZone(double x, double y, int giro);
    int levelZone(int zone);
    
    void drawIndividualSociogram( sociometricTest *myTest, double x, double y);
    void drawGroupSociogram( sociometricTest *myTest, double x, double y);
    void drawMeaning(QRect rect);
    void drawSociometricValueSignificant (QRect rect);
    void drawTitle(int x, int y, QString title);
    bool isPaintEvent;


public slots:

private slots:

private:
    void drawSimbol(QString sex, QString identificativ, double x, double y, double side);
    void drawArrow(double x1, double y1, double x2, double y2, QString typeArrow);
    double evaluatePosition(int cx[], int cx[], QString typeSociogram);
    void sociometricAlgoritm(int cx[], int cy[], int variants = 1000, QString typeSociogram = QString::null);
    int randZone(int alumno, QString parametro);
    double randAngle(int alumno, int zone);
    double getAngle(double x, double y, double ox, double oy);
    int getZone(double x, double y, double ox, double oy);
    
    QPoint clickPos;
    QTime  time;
    sociometricTest *myTest;
    QWidget *parent;
    const char *name;
    QPainter *myPainter;
    
    
protected:

    void paintEvent( QPaintEvent *);
    void mousePressEvent( QMouseEvent *);
    void mouseMoveEvent( QMouseEvent *);

    double simbolDiameter;
    int numZones;
    double radioSociogram;
    double longZone;
    int relativeFirstZone;
    int relativeSecondZone;
    int relativeThirdZone;
    

};

#endif
