/***************************************************************************
                          ksubtiledoc.cpp  -  description
                             -------------------
    begin                : di feb  4 15:33:11 CET 2003
    copyright            : (C) 2003 by Tom Deblauwe
    email                : tom.deblauwe@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qdir.h>
#include <qwidget.h>
#include <qregexp.h>
#include <qstringlist.h>
#include <qtabwidget.h>
#include <qurloperator.h>
#include <qurlinfo.h>
#include <qtextcodec.h>

// include files for KDE
#include <klocale.h>
#include <kmessagebox.h>
#include <kio/job.h>
#include <kio/netaccess.h>
#include <ksqueezedtextlabel.h>

// application specific includes
#include "ksubtiledoc.h"
#include "ksubtile.h"
#include "ksubtileview.h"
#include <csubtitle.h>
#include <csubtitles.h>
#include <subtitlenavigator.h>

QList<KSubtileView> *KSubtileDoc::pViewList = 0L;

KSubtileDoc::KSubtileDoc(QWidget *parent, const char *name) : QObject(parent,name)
{
    if(!pViewList)
    {
        pViewList = new QList<KSubtileView>();
    }

    pViewList->setAutoDelete(true);

    subtitles = 0;
}

KSubtileDoc::~KSubtileDoc()
{
    //  delete subtitles;
}

void KSubtileDoc::addView(KSubtileView *view)
{
    pViewList->append(view);
}

void KSubtileDoc::removeView(KSubtileView *view)
{
    pViewList->remove
    (view);
}
void KSubtileDoc::setURL(const KURL &url)
{
    doc_url=url;
}

const KURL& KSubtileDoc::URL() const
{
    return doc_url;
}

void KSubtileDoc::slotUpdateAllViews(KSubtileView *sender)
{
    KSubtileView *w;
    if(pViewList)
    {
        for(w=pViewList->first(); w!=0; w=pViewList->next())
        {
            if(w!=sender)
                w->repaint();

            //w->tw_editor->setCurrentPage( w->tw_editor->indexOf(w->tw_editor->currentPage()) );
        }
    }

}

void KSubtileDoc::setModified(bool m)
{
    modified=m;
    //save must get enabled and disabled
    emit docModified(m);
}

bool KSubtileDoc::saveModified()
{
    bool completed=true;

    if(modified)
    {
        KSubtileApp *win=(KSubtileApp *) parent();
        int want_save = KMessageBox::warningYesNoCancel(win, i18n("The current file has been modified.\n Do you want to save it?"), i18n("Warning"));
        switch(want_save)
        {
        case KMessageBox::Yes:
            if (doc_url.fileName() == i18n("Untitled"))
            {
                win->slotFileSaveAs();
            }
            else
            {
                saveDocument(URL());
            };

            //deleteContents();
            completed=true;
            break;

        case KMessageBox::No:
            setModified(false);
            //deleteContents();
            completed=true;
            break;

        case KMessageBox::Cancel:
            completed=false;
            break;

        default:
            completed=false;
            break;
        }
    }

    return completed;
}

void KSubtileDoc::closeDocument()
{
    deleteContents();
}

bool KSubtileDoc::newDocument()
{
    modified=false;
    doc_url.setFileName(i18n("Untitled"));

    //delete current contents and make a new object

    deleteContents();

    subtitles = new CSubtitles();

    //stop any playing movies

    KSubtileView* current = (KSubtileView*) pViewList->first();
    if(current != 0)
    {
        current->getPlayer()->stopPlayingMovie();
    }

    //check for mplayer again(or does this bug people?)

    //emit checkPlayer();

    //clear navigator bar

    if(current != 0)
    {
        current->pm_editor_navigator_bar->drawSubs(subtitles, true);
    }

    //set the encoding to null
    if(text_codec != "")
    {
		text_codec = "";
    }
    
    return true;
}

bool KSubtileDoc::openDocument(const KURL& url, const char * /*format*/ /*=0*/)
{
    QString tmpfile;
    KIO::NetAccess::download( url, tmpfile , NULL);
    /////////////////////////////////////////////////
    // TODO: Add your document opening code here
    /////////////////////////////////////////////////

    bool succeeded = false;
    CSubtitles* tmpSubtitles = new CSubtitles();
    //indicate that some subtitles couldn't be added to tmpSubtitles
    bool subtitles_problems = false;
    bool subtitles_problems_correctable = false;
    CSubtitles* problemSubtitles = new CSubtitles();
    
    QFile file( tmpfile );
    if(tmpfile.contains( QRegExp( "\\.srt$", false, false ) ) >= 1)
    {

        if(file.open( IO_ReadOnly))
        {
            QTextStream stream( &file );
            QString line;
            QTextCodec* codec = QTextCodec::codecForName(text_codec);
	    if(codec) {
	            stream.setCodec(codec);
            }
			
            while(!stream.eof())
            {
                line = stream.readLine(); // line of text excluding '\n'
                
                //look for timing indication
                while(line.contains(QRegExp("^[0-9][0-9]:[0-9][0-9]:[0-9][0-9],[0-9][0-9][0-9] --> [0-9][0-9]:[0-9][0-9]:[0-9][0-9],[0-9][0-9][0-9]", false, false )) < 1)
                {
                    if(stream.eof())
                    {
                        break;
                    }
                    else
                    {
                        line = stream.readLine();
                    }
                    
                }
                // line contains now timing information

                //split start and endtime
                QStringList timeList = QStringList::split( QRegExp( " --> " ), line, false);
                //starttime
                //split starttime with ':'
                QStringList startTimeList = QStringList::split( QRegExp( ":" ), timeList[0], false);              //split seconds and mseconds
                QStringList startTimeSecondsList = QStringList::split( QRegExp( "," ), startTimeList[2], false);
                QTime startTime = QTime(startTimeList[0].toInt(), startTimeList[1].toInt(), startTimeSecondsList[0].toInt(), startTimeSecondsList[1].toInt());
                //endtime
                //split starttime with ':'
                QStringList endTimeList = QStringList::split( QRegExp( ":" ), timeList[1], false);
                //split seconds and mseconds
                QStringList endTimeSecondsList = QStringList::split( QRegExp( "," ), endTimeList[2], false);
                QTime endTime = QTime( endTimeList[0].toInt(), endTimeList[1].toInt(), endTimeSecondsList[0].toInt(), endTimeSecondsList[1].toInt());
                //printf("start: %s | end: %s", startTime.toString(QString("hh:mm:ss,zzz")).latin1(), endTime.toString(QString( "hh:mm:ss,zzz")).latin1());
                QString line1,line2;
                if(!stream.eof())
                {
                    //read line1
                    line = stream.readLine();
                    if(!line.isEmpty())
                    {
                        line1 = QString(line);
                        if(!stream.eof())
                        {
                            //try to read line2
                            line = stream.readLine();
                            if(!line.isEmpty())
                            {
                                line2 = QString(line);
                            }
                        }
                    }
                }
                if(!line1.isEmpty())
                {
                    if(line2.isNull())
                    {
                        line2 = QString("");
                    }
                    CSubtitle* sub = new CSubtitle(CSubtitles::getMSecs(startTime), CSubtitles::getMSecs(endTime), line1, line2);
                    bool ok = tmpSubtitles->addSubtitle(sub);
                    if(!ok) //could not add a subtitle to the collection
                    {
                        //                  printf("problems add: %s", line1.latin1());
                        problemSubtitles->addSubtitle(sub);
                        subtitles_problems = true;
                        //we have one line and timing information, so we can eventually maybe correct the problem
                        subtitles_problems_correctable = true;
                    }
                }
                else
                {
                    //                printf("problems line1: %s", line1.latin1());
                    //no first line, so we ignore this one
                    subtitles_problems = true;
                }                

            }
            file.close();	    
        }


        bool b_openmovie = false;

        //check to open avi/mpg file too
        QString test( url.path() );
        test.remove( QRegExp( "\\.srt$", false, false ) );
        test.append( QString(".avi") );
        QFileInfo aviInfo( test );
        if(aviInfo.exists() && aviInfo.isReadable())
        {
            b_openmovie = true;
            //      printf("ok found avi file too\n");
        }
        else
        {
            test.remove( QRegExp( "\\.avi$", false, false ) );
            test.append( QString(".mpg") );
            QFileInfo mpgInfo( test );
            if(mpgInfo.exists() && mpgInfo.isReadable())
            {
                b_openmovie = true;
            }
            //      printf("not found avi file\n");
        }
        if(b_openmovie)
        {
            KSubtileView* current = (KSubtileView*) pViewList->first();
	    //stop the movie if it is still playing
	    current->getPlayer()->stopPlayingMovie();
	    
            if(current != 0)
            {
                current->getPlayer()->openMovie( test );
            }
        }

    }

    //check if subtitles were added
    if(tmpSubtitles->isEmpty())
    {
        succeeded = false;
    }
    else
    {
        succeeded = true;
        modified=false;
        if(subtitles_problems)
        {
            // 	    printf("subtitles pointer: %d\n", subtitles);
            // 	    printf("tmpsubtitles pointer: %d\n", tmpSubtitles);
            if(subtitles_problems_correctable = false)
            {
                //some weird shit happened, but we left them out and we can't possibly know where the subs should go
                KMessageBox::sorry((KSubtileApp *) parent(), i18n("Some subtitles were not included because they had no timing information!"), i18n("Sorry"));
            }
            else
            {
                //we have a time and at least one line of text, but the sub doesn't fit in
                if(KMessageBox::warningContinueCancel((KSubtileApp *) parent(), i18n("Some subtitles are not included because their timing overlapped with other subtitles!  Do you want to add them anyway, but of course with their timings altered so they fit in.  Include anyway?"), i18n("Include anyway?"),
                                                      i18n("Include"))==KMessageBox::Continue)
                {

                    //go through the list and try to add them with some changes in timing
                    QPtrListIterator<CSubtitle> it = problemSubtitles->getIterator();
                    CSubtitle* problemSub;
                    while ( (problemSub = it.current() ) != 0 )
                    {
                        ++it;
                        // 					printf("\nproblem:%s", problemSub->getLine1().latin1());
                        bool wentok = tmpSubtitles->addSubtitleWithWrongTiming(problemSub);
                        if(!wentok)
                        {
                            problemSubtitles->removeSubtitle(problemSub);
                        }
                    }
                }
            }

            doc_url.setPath(url.path());
            //this is not like the original subtitle movie, so indicate this
            //by setting modified to true
            setModified(true);
        }
        else
        {
            //no problems, we have loaded the whole original file in memory as it was on disk
            setModified(false);
            doc_url.setPath(url.path());
        }

        delete problemSubtitles;

        subtitles->setAutoDelete(true);
        delete subtitles;
        subtitles = NULL;

        subtitles = tmpSubtitles;

        //en/dis able play-with-subtitles box
        KSubtileView* current = (KSubtileView*) pViewList->first();
        if(current != 0)
        {
            current->getPlayer()->checkEnableWithSubtitles();
            //draw the subtitles in the navigator bar
            current->pm_editor_navigator_bar->drawSubs(subtitles, true, subtitles->getFirstSubtitle());
        }	
    }

    KIO::NetAccess::removeTempFile( tmpfile );

    return succeeded;
}

bool KSubtileDoc::saveDocument(const KURL& url, const char */*format*/ /*=0*/)
{
    
	QFile file( url.path() );
    if ( file.open( IO_WriteOnly ) )
    {
		
        QTextStream stream( &file );
		
		if(text_codec != "")
		{
			stream.setCodec( QTextCodec::codecForName(text_codec) );
		}
		else
		{
			stream.setCodec( QTextCodec::codecForLocale() );
		}
	
        subtitles->subDump(stream, CSubtitles::subFormatSRT);
        file.close();
        setModified(false);
        doc_url.setPath(url.path());
        return true;
    }
    KMessageBox::sorry((KSubtileApp *) parent(), i18n("There was a problem saving this file! The file isn't saved.  Maybe you should check the write permissions? Or save it as another file?"), i18n("Sorry"));
    return false;
}

void KSubtileDoc::deleteContents()
{
    /////////////////////////////////////////////////
    // TODO: Add implementation to delete the document contents
    /////////////////////////////////////////////////

    if(subtitles != 0)
    {
        //delete collection of subtitles
        //make sure the CSubtitle elements are also deleted
        subtitles->setAutoDelete(true);
        delete subtitles;
        subtitles = NULL;
    }

}
