// part of KSUDOKU - by Francesco Rossi <redsh@email.it> 2005

#include "ksudokuview.h"

#include <qpainter.h>
#include <qlayout.h>

#include <kurl.h>

#include <ktrader.h>
#include <klibloader.h>
#include <kmessagebox.h>
#include <krun.h>
#include <klocale.h>
#include <qpaintdevicemetrics.h>
#include <kio/netaccess.h>
#include <qfile.h>
#include "ksudoku.h"
#include "knewdlg.h"

ksudokuView::ksudokuView(QWidget *parent)
    : QWidget(parent),
      DCOPObject("ksudokuIface")
{
	isWaitingForNumber = -1;
	puzzle = 0;
	completed_puzzle = 0;
	highlighted = -1;
	stack_d = 0;
  
}

void ksudokuView::setup(int order, int difficulty, int s, bool dub)
{
	std::srand( time(0) );//srandom((unsigned)time( NULL ) );
	puzzle_mark_wrong=true;
	btns = 0;
	current_selected_number = 0;
	
	puzzle           = new skPuzzle(order);	
	completed_puzzle = new skPuzzle(order);
	
	
	if(order == 9)
		mySolver = solver09;
	else if(order == 16)
		mySolver = solver16;
	else	
		mySolver = solver25;

	//printf("%d\n", mySolver->order);
	
	createbuttons(order);

	if(!dub)
		genPuzzle(difficulty,s);///CREATE PUZZLE

	update();
	resizeEvent(0);
}

ksudokuView::~ksudokuView()
{
	if(puzzle) delete puzzle;
	if(completed_puzzle) delete completed_puzzle;
}

void ksudokuView::print(QPainter *p, int height, int width)
{
    // do the actual printing, here
	QPaintDeviceMetrics     metrics (p->device());
	int sz = ((metrics.width()<metrics.height()) ? metrics.width():metrics.height()) / (puzzle->order+6);
	QFont f;
	QPen pen(QColor(50,50,50));

	ITERATE(i,puzzle->order+1)
	{

		if(i%puzzle->base==0) pen.setWidth(4);
		else pen.setWidth(1);
		p->setPen(pen);
		
		p->drawLine(0, sz*(i), sz*(puzzle->order), sz*(i));
		p->drawLine(sz*(i), 0, sz*(i), sz*(puzzle->order));
	}
	
	
	ITERATE(x, puzzle->order)
		ITERATE(y, puzzle->order)
			if(btns[x*puzzle->order + y]->value != 0)
			{
				QRect r(x*sz,y*sz,sz,sz);
				f.setPointSizeFloat(1.8*sz/6.2 );
				p->setFont(f);
				p->drawText(r, QPainter::AlignCenter, QString( (QChar) ((char) puzzle->zerochar + (char)btns[x*puzzle->order + y]->value)));			
			}
}

QString ksudokuView::currentURL()
{
	return "";
}

void ksudokuView::openURL(QString url)
{
    openURL(KURL(url));
}

void ksudokuView::openURL(const KURL& url)
{
	
}

void ksudokuView::slotOnURL(const QString& url)
{
    emit signalChangeStatusbar(url);
}

void ksudokuView::slotSetTitle(const QString& title)
{
    emit signalChangeCaption(title);
}

int ksudokuView::genPuzzle(int difficulty, int simmetry,  bool dub)
{
    ((ksudoku*)parent())->t.start();

	std::srand( time(0) );
	if(dub==false)
	{
		mySolver->solve(puzzle, 1, puzzle);
		mySolver->copy(completed_puzzle, puzzle);
		int remaining = puzzle->size - mySolver->remove_numbers(puzzle,difficulty,simmetry,0);
	
		printf("REMAINING NUMBERS %d GIVEN %d DIFFICULTY : %d\n", remaining, puzzle->size-remaining, difficulty);
		for(int i=0; i<puzzle->order; i++)
			for(int j=0; j<puzzle->order; j++)
			{
				if(puzzle->numbers[i*puzzle->order+j] !=0) btns[i*puzzle->order+j]->given = true;
				btns[i*puzzle->order+j]->setValue(puzzle->numbers[i*puzzle->order+j]);
			}
		push();
	}
	else
	{
		ITERATE(i,puzzle->size)if(puzzle->numbers[i] != 0)
			ITERATE(j,mySolver->g->optimized_d[i]) if(puzzle->numbers[mySolver->g->optimized[i][j]] != 0) 
				if(i!=mySolver->g->optimized[i][j]) if(puzzle->numbers[i] == puzzle->numbers[mySolver->g->optimized[i][j]])
				{
					KMessageBox::information(this, i18n("The puzzle you entered contains some errors."));
					return -1;
				}
		int forks =0;
		if(mySolver->solve(puzzle, 1, completed_puzzle, &forks) == 1)
		{
			QString s = "";
			s.sprintf("One solution has been found (if you want to see it click on 'Solve' button)\nDIFFICULTY: I did %d guesses (forks) solving the puzzle.\nSearch for other solutions?", forks);
			if(KMessageBox::questionYesNo(this, s) != 4)
			{
				if(mySolver->solve(puzzle, 2, 0) > 1)
					KMessageBox::information(this, i18n("The puzzle you entered has multiple solutions."));
				else
					KMessageBox::information(this, i18n("The puzzle you entered has only one solution."));
			}
		}
		else
		{
			KMessageBox::questionYesNo(this, i18n("Sorry, No solutions have been found."));
			return -1;
		}

	}

	return 0;
}

void ksudokuView::btn_enter(int y, int x) // oops
{
	isWaitingForNumber = -1;
	for(int i=0; i<puzzle->size ; i++) for(int j=0; j<3 ; j++)  btns[i]->highlighted[j] = false;
	for(int i=0; i<puzzle->order; i++)
	{
		btns[i+y*puzzle->order]->highlighted[0] = true;
		btns[i*puzzle->order+x]->highlighted[1] = true;
		int sx = (x/puzzle->base) * puzzle->base;
		int sy = (y/puzzle->base) * puzzle->base;
		btns[sx+(i%puzzle->base) + (sy + (i/puzzle->base))*puzzle->order]->highlighted[2] = true;
	}
	for(int i=0; i<puzzle->size ; i++) btns[i]->update();
}


void ksudokuView::paintEvent(QPaintEvent *)
{

}

void ksudokuView::btn_leave(int x, int y){}
	
void ksudokuView::createbuttons(int ord)
{	
	puzzle->size = puzzle->order*puzzle->order;
	if(btns)
	{
		for(int i=0; i<puzzle->size; i++) //2FIX
		{
			btns[i]->hide();
		}
		delete[] btns;
	}

	btns = (QSudokuButton**) malloc(sizeof(QSudokuButton*) *puzzle->size);	
	char* t = new char[4];
				
	for(int i=0; i<puzzle->size; i++) //2FIX
	{
		sprintf(t, "%d", i);
		btns[i] = new QSudokuButton(this, t, (i/puzzle->order), i%puzzle->order);
		btns[i]->show();
		connect(btns[i], SIGNAL(clicked2(int, int)), this, SLOT(slotHello(int, int)));
		connect(btns[i], SIGNAL(rightclicked(int, int)), this, SLOT(slotRight(int, int)));
		connect(btns[i], SIGNAL(enter(int,int)), this, SLOT(btn_enter(int,int)));
		connect(btns[i], SIGNAL(leave(int,int)), this, SLOT(btn_leave(int,int)));

		connect(btns[i], SIGNAL(beginHighlight(int)), this, SLOT(beginHighlight(int)));
		connect(btns[i], SIGNAL(finishHighlight()), this, SLOT(finishHighlight()));
	}

}

void ksudokuView::beginHighlight(int val)
{
	if(puzzle == 0) return;
	if(mySolver == 0) return;

	highlighted = val;
	if(val == 0) highlighted = current_selected_number;
	if(highlighted == 0) return;
	
	ITERATE(i, puzzle->size) btns[i]->highlighted[3] = 0;

	ITERATE(i, puzzle->size)
		if(btns[i]->value == highlighted)
			ITERATE(j,mySolver->g->optimized_d[i])
				btns[mySolver->g->optimized[i][j]]->highlighted[3] = 1;
	
	ITERATE(i,puzzle->size) btns[i]->paintEvent(0);
}

void ksudokuView::finishHighlight()
{
	highlighted = -1;
	ITERATE(i, puzzle->size)
	{ 
		btns[i]->highlighted[3] = 0;
		btns[i]->paintEvent(0);
	}
}
	
void ksudokuView::resizeEvent(QResizeEvent * )
{
	if(puzzle)
	if(btns)for(int i=0; i<puzzle->size; i++) //2FIX
		if(btns[i]) btns[i]->resize();
}
	
void ksudokuView::slotHello(int x, int y)
{
	//printf("CLICK %d %d\n", x, y);
	if(btns[x*puzzle->order + y]->given == true)
	{
		current_selected_number = btns[x*puzzle->order + y]->value;
		emit changedSelectedNum();
	}
	else
	{
		btns[x*puzzle->order + y]->setValue(current_selected_number);
	}
}

void  ksudokuView::slotRight(int x, int y)
{
	if(btns[x*puzzle->order + y]->given == false)
	{
		if(mouseOnlySuperscript == 1)
			btns[x*puzzle->order + y]->justmark(current_selected_number);
		else
		{
			isWaitingForNumber = x*puzzle->order+y;
				btns[x*puzzle->order + y]->paintEvent(0);
		}
	}
}

void  ksudokuView::push()
{
	if(stack_d > 255) return;
	if(puzzle == 0) return;
	if(btns[0] == 0) return;

	ITERATE(i,puzzle->size)
	{
		//stack[stack_d].text[i]   = btns[i]->text;
		stack[stack_d].value[i]  = btns[i]->value;
		//stack[stack_d].marked[i] = btns[i]->justmarker;
		stack[stack_d].given[i]  = btns[i]->given;
		btns[i]->paintEvent(0);
	}	
	stack_d++;
}
void  ksudokuView::pop()
{
	if(puzzle == 0) return;
	if(btns[0] == 0) return;
	if(stack_d == 0) {KMessageBox::information(this, "Error: The checkpoint stack is empty."); return;}	

	stack_d--;
	ITERATE(i,puzzle->size)
	{
		//btns[i]->text = stack[stack_d].text[i];
		btns[i]->given = stack[stack_d].given[i];
		btns[i]->value = stack[stack_d].value[i];
		btns[i]->setValue(btns[i]->value );
		//btns[i]->justmarker = stack[stack_d].marked[i];
		btns[i]->paintEvent(0);
	}	
	if(stack_d == 0) stack_d = 1;
}

#include "ksudokuview.moc"
