/***************************************************************************
 *   Copyright (C) 2004 by Stefan Kombrink                                 *
 *   katakombi@web.de                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _KSYNAPTICS_H_
#define _KSYNAPTICS_H_

#include <kcmodule.h>
#include <kaboutdata.h>

#include "syntp.h"

#include <qframe.h>
#include <qevent.h>

class ksDlg;

class ksynaptics: public KCModule
{
    Q_OBJECT

public:
    ksynaptics( QWidget *parent=0, const char *name=0, const QStringList& = QStringList() );
    ~ksynaptics();

    //! autodetect / load stored settings (once at start-up)
    virtual void load(); 
    //! save current settings
    virtual void save(); 
    //! restores hard-wired default settings
    virtual void defaults();

    virtual int buttons();
    virtual QString quickHelp() const;
    virtual const KAboutData *aboutData()const
    { return myAboutData; };

public slots:
    // general

    //! displays the current hardware settings
    void displayConfig();

    //! enables all proper widgets if the touch pad driver is working and enabled
    void enableFunctionality();

    //! disables all widgets except the tab widget
    void disableFunctionality();

    // update display dependancies    
    void depTouchPad(int);
    void depScrollMode(int);
    void depScrollHoriz(bool);
    void depScrollVert(bool);
    void depTapping(bool);
    void depTapSmart(bool);
    void depMultiFinger(int);

    // update settings
    void updateTouchPad(int);
    void updateScrollMode(int);
    void updateScrollHoriz(bool);
    void updateScrollVert(bool);
    void updateTapping(bool);
    void updateTapSmart(bool);
    void updateMultiFinger(int);

    void updateHSS(int);
    void updateVSS(int);
    void updateCSS(int);
    void updateTT(int);
    void updateSMD(int);
    void updatePS(int);

    void updateEdges(int);

private:
    //! info about the module
    KAboutData *myAboutData;
    //! embedds the dialog
    ksDlg *myDlg;
    //! object to access the touch pad
    SynTouchPad myTp;
    //! draws the frame containing active edges and corners
    //myFrame myCSEdgesF;
    //! holds multifinger configuration
    unsigned int myFinger[3];
};

#endif
