/***************************************************************************
 *   Copyright (C) 2004 Nadeem Hasan <nhasan@kde.org>                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SYNCONFIGWIDGET_H
#define SYNCONFIGWIDGET_H

#include "synconfigwidgetbase.h"
#include "adjborderwizard.h"


class SynConfigWidget : public SynConfigWidgetBase
{
  Q_OBJECT

  public:
    SynConfigWidget( QWidget *parent, const char *name );
    void load();
    void save();

  protected slots:
    void useTappingChanged( bool b );
    void useSmartModeChanged( bool b );
    void tapFingerChanged( int index );
    void tapButtonChanged( int id );
    void horizScrollChanged( bool b );
    void vertScrollChanged( bool b );
    void circScrollChanged( bool b );
    void alpsOptionClicked( );

    void widgetModified();
    void invokeBorderWizard();

  signals:
    void changed();

  private:
    AdjBorderWizard *m_borderWizard;
};
#endif // SYNCONFIGWIDGET_H
