/* This file is part of the KDE project
   Copyright (C) 2004 Nadeem Hasan <nhasan@kde.org>
   and Stefan Kombrink <katakombi@web.de>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#include "syndock.h"

#include <kiconloader.h>
#include <kdebug.h>
#include <klocale.h>
#include <kshortcut.h>
#include <kpopupmenu.h>
#include <kaction.h>
#include <kactioncollection.h>

#include <qstring.h>
#include <qwidget.h>
#include <qpixmap.h>
#include <qpopupmenu.h>
#include <synconfig.h>
#include <qtooltip.h>

SynDock::SynDock( QWidget *parent, const char *name )
    : KSystemTray( parent, name )
{                    
  KLocale::setMainCatalogue( "ksynaptics" );
	
  m_dockPixmapEnabled = KSystemTray::loadIcon( "ksynaptics" );
  m_dockPixmapDisabled = KSystemTray::loadIcon( "syndockdisabled" );

  setPixmap( m_dockPixmapEnabled );
  QToolTip::add( this, i18n( "KSynaptics: Enable and disable your touch pad temporarily" ) );

  m_syndaemonProc = new KProcess( this );
  m_synclientProc = new KProcess( this );

  QString delay;
  delay = QString::number( 0.001f * SynConfig::smartModeDelay(), 'f', 4 );

  *m_syndaemonProc << "syndaemon" << "-i" << delay << "-t" << "-k";

  if ( ! m_syndaemonProc->start() )
    kdDebug() << "Error: could not launch syndaemon process!" << endl;
  else
    kdDebug() << "launched syndaemon process" << endl;


  g_enableDisableText_Enabled = i18n( "Disable touch pad temporarily" );
  g_enableDisableText_Disabled = i18n( "Reenable touch pad" );
  
  g_disableTypeText_Full = i18n( "Disabling both motion and tapping" );
  g_disableTypeText_Tapping = i18n( "Just disabling tapping" );

  m_enableDisableAction =
  new KAction( 
			g_enableDisableText_Enabled,
			KKeySequence( i18n( "Ctrl+Alt+P" ) ), 
			this,
			SLOT( toggleEnableDisable() ),
			actionCollection(),
			"Toggle Pad"
			);

  m_disableTypeAction =
  new KAction( 
			g_disableTypeText_Tapping, 
			KKeySequence( i18n( "T" ) ), 
			this,
			SLOT( toggleDisableType() ),
			actionCollection(),
			"Disable Type"
			);

  // initialize default values
  m_disabled = false;
  m_disableType = DT_TAPPING;

  m_enableDisableAction->plug( contextMenu() );
  m_disableTypeAction->plug( contextMenu() );
  
  m_toggle_pad = new KGlobalAccel( this );
  m_toggle_pad->insert( "Toggle Pad Accel", i18n( "Toggle Pad" ),
		  				i18n( "switch the touch pad on and off temporarily" ),
                       	KKeySequence( i18n( "ALT+CTRL+P" ) ), 0, 
					   	this, SLOT( toggleEnableDisable() )  );
  
  m_toggle_pad->updateConnections();

  m_popup = new KPassivePopup( this );
}

SynDock::~SynDock()
{
  if ( m_syndaemonProc->isRunning() )
    if ( ! m_syndaemonProc->kill() )
      kdDebug() << "Error: could not kill syndaemon process!" << endl;
    else
      kdDebug() << "killed syndaemon process" << endl;
  else
    kdDebug() << "syndaemon already stopped!" << endl;

  kdDebug() << "restoring default settings..." << endl;

  m_synclientProc->clearArguments();
  *m_synclientProc << "synclient" << "TouchPadOff=0";
  m_synclientProc->start();
}

void SynDock::showPopup(const QString & caption, QPixmap & icon)
{
  m_popup->message( i18n( "Ksynaptics message" ), caption, icon, this);
  m_popup->show();
}

void SynDock::toggleEnableDisable()
{
  kdDebug() << "toggleEnableDisable" << endl;
  m_disabled = !m_disabled;

  // disable syndaemon if pad is disabled...
  if ( m_disabled ) m_syndaemonProc->kill();

  m_enableDisableAction->setText( 
		  m_disabled? g_enableDisableText_Disabled : g_enableDisableText_Enabled );

  m_synclientProc->clearArguments();

  QString paramStr = QString::number( m_disabled? m_disableType : DT_NONE );

  *m_synclientProc << "synclient" << "TouchPadOff=" + paramStr;

  m_synclientProc->start();

  setPixmap( m_disabled? m_dockPixmapDisabled:m_dockPixmapEnabled );


  QString accelStr = i18n( (m_toggle_pad->shortcut( "Toggle Pad Accel" )).toString().ascii() );
  
  QString msgStrDisabled =
	  i18n( "Touch pad disabled! <br>Press %1 to enable it again..." ).arg( accelStr );

  QString msgStrEnabled =
	  i18n( "Touch pad enabled!<br>Press %1 to disable it again..." ).arg( accelStr );
  
  if ( m_disabled )
    showPopup( msgStrDisabled, m_dockPixmapDisabled );
  else
	showPopup( msgStrEnabled, m_dockPixmapEnabled );

  // enable syndaemon if pad is enabled
  if ( !m_disabled ) m_syndaemonProc->start();
}


void SynDock::toggleDisableType()
{
  kdDebug() << "toggleDisableType" << endl;

  if ( m_disableType == DT_FULL )
  { 
	m_disableType = DT_TAPPING;
	m_disableTypeAction->setText( g_disableTypeText_Tapping );
  }
  else
  {
	m_disableType = DT_FULL;
	m_disableTypeAction->setText( g_disableTypeText_Full );
  }
  
  
  m_synclientProc->clearArguments();

  QString paramStr;
  paramStr = QString::number( m_disabled? m_disableType : DT_NONE );

  *m_synclientProc << "synclient" << "TouchPadOff=" + paramStr;

  m_synclientProc->start();		  
}

#include "syndock.moc"
