/***************************************************************************
 *   Copyright (C) 2004 by Stefan Kombrink <katakombi@web.de>              *
 *   Copyright (C) 2004 by Nadeem Hasan <nhasan@kde.org>                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
#ifndef _SYNSHM_H_
#define _SYNSHM_H_

#include <X11/Xdefs.h>

/***************************************************************************
 * Public definitions (from Peter Osterlunds synaptics driver)
 ***************************************************************************/

typedef enum
{
    RightTop = 0,             /* Right top corner */
    RightBottom,                 /* Right bottom corner */
    LeftTop,                 /* Left top corner */
    LeftBottom,                 /* Left bottom corner */
    OneFinger,                 /* Non-corner tap, one finger */
    TwoFingers,                 /* Non-corner tap, two fingers */
    ThreeFingers,                 /* Non-corner tap, three fingers */
    MaxTap
} TapType;

struct SynapticsHwInfo
{
    unsigned int model_id;          /* Model-ID */
    unsigned int capabilities;      /* Capabilities */
    unsigned int ext_cap;           /* Extended Capabilities */
    unsigned int identity;          /* Identification */
    Bool hasGuest;                  /* Has a guest mouse */
};

// SHM Id
#define SHM_SYNAPTICS 23947

typedef struct _SynapticsSHM
{
	/*  Current version */
	int version;

    /* Current device state */
    int x, y;                   /* actual x, y coordinates */
    int z;                  /* pressure value */
    int numFingers;             /* number of fingers */
    int fingerWidth;                /* finger width value */
    int left, right, up, down;          /* left/right/up/down buttons */
    Bool multi[8];
    Bool middle;
    int guest_left, guest_mid, guest_right; /* guest device buttons */
    int guest_dx, guest_dy;             /* guest device movement */

    /* Probed hardware properties */
    struct SynapticsHwInfo synhw;

    /* Parameter data */
    int left_edge, right_edge, top_edge, bottom_edge; /* edge coordinates absolute */
    int finger_low, finger_high;        /* finger detection values in Z-values */
    unsigned long tap_time;
    int tap_move;               /* max. tapping time and movement in packets and coord. */
    unsigned long tap_time_2;           /* max. tapping time for double taps */
    unsigned long click_time;           /* The duration of a single click */
    Bool fast_taps;
    int emulate_mid_button_time;        /* Max time between left and right button presses
to
                           emulate a middle button press. */
    int scroll_dist_vert;           /* Scrolling distance in absolute coordinates */
    int scroll_dist_horiz;          /* Scrolling distance in absolute coordinates */
    double min_speed, max_speed, accl;      /* movement parameters */
    int edge_motion_min_z;          /* finger pressure at which minimum edge motion speed
is set */
    int edge_motion_max_z;          /* finger pressure at which maximum edge motion speed
is set */
    int edge_motion_min_speed;          /* slowest setting for edge motion speed */
    int edge_motion_max_speed;          /* fastest setting for edge motion speed */
    Bool edge_motion_use_always;        /* If false, egde motion is used only when dragging */

    Bool updown_button_scrolling;       /* Up/Down-Button scrolling or middle/double-click */
    Bool leftright_button_scrolling;    /* Left/Right-Button scrolling, or two lots of middle button */

    Bool updown_button_repeat;          /* if up/down button is being used to scroll/auto-repeat */
    Bool leftright_button_repeat;       /* if left/right button is being used to scroll/auto-repeat */
    int scroll_button_repeat;           /* time (in ms) between scrolling events being sent */
                                        /* when holding down scroll buttons */
    int touchpad_off;              /* Switches the touchpad off */
    Bool guestmouse_off;            /* Switches the guest mouse off */
    Bool locked_drags;              /* Enable locked drags */
    int tap_action[MaxTap];            /* Button to report on tap events */
    Bool circular_scrolling;            /* Enable circular scrolling */
    double scroll_dist_circ;            /* Scrolling angle radians */
    int circular_trigger;           /* Trigger area for circular scrolling */
    Bool circular_pad;              /* Edge has an oval or circular shape */
    Bool palm_detect;               /* Enable palm detection */
    int palm_min_width;             /* Palm detection width */
    int palm_min_z;                 /* Palm detection pressure */
    double coasting_speed;          /* Coasting threshold scrolling speed */
} SynapticsSHM;

#endif
