/***************************************************************************
 *   Copyright (C) 2004 by Stefan Kombrink                                 *
 *   katakombi@web.de                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "myframe.h"

#include <qevent.h>
#include <qpainter.h>
#include <qcolor.h>
#include <qcursor.h>
#include <qevent.h>
#include <qpixmap.h>
#include <kdebug.h>

#include "fingerprint.xpm"

myFrame::myFrame(QWidget* parent, const char* name) : QFrame(parent, name)
{
    kdDebug() << k_funcinfo << endl;
    
    mPadMode = NoTrigger;
    setFrameShape(QFrame::Box);
    mPixmap = new QPixmap( fingerprint );
}

myFrame::~myFrame()
{
    kdDebug() << k_funcinfo << endl;
    
    delete mPixmap;
}

void myFrame::mouseMoveEvent(QMouseEvent *)
{
    kdDebug() << k_funcinfo << endl;
}

void myFrame::displayState(int i)
{
    kdDebug() << k_funcinfo << endl;
    
    // range checking
    if ( ( i < NoTrigger ) or ( i >= PadModeMax ) )
        mPadMode = NoTrigger;
    else
        mPadMode = (PadMode) i;

    repaint();
}

void myFrame::paintEvent(QPaintEvent *event)
{
    kdDebug() << k_funcinfo << endl;
    
    const int r = 10;
    
    // permutations...
    const int p[] = { 1+2+4+8, 1+2, 2, 2+4, 4, 4+8, 8, 8+1, 1 };
    
    const int x1 = 0;
    const int y1 = 0;
    const int x2 = width() - 1;
    const int y2 = height() - 1;
    
    const int o=5;
    
    // you don't need to redraw the stuff
    if ( !event->erased() ) return;
    
    QPainter myPainting(this);
    
    // erase whole frame
    myPainting.setBrush( QPainter::SolidPattern );
    myPainting.setBrush( QColor( "White" ) );
    myPainting.drawRect( 0, 0, width(), height() );
    
    // draw grid
    // TODO improve this drawing
    myPainting.setBrush( QPainter::CrossPattern );
    myPainting.drawRect( x1, y1, x2+r/2, y2+r/2 );
    
    // paint the grid only?
    if ( mPadMode == NoTrigger ) return;


    // draw the proper amout of finger tips 
    if ( mPadMode >= OneFinger )
        myPainting.drawPixmap( 0, 0, *mPixmap ); 

    if ( mPadMode >= TwoFingers )
        myPainting.drawPixmap( 37, 0, *mPixmap );
    
    if ( mPadMode >= ThreeFingers )
        myPainting.drawPixmap( 20, 27, *mPixmap );
    

    // otherwise draw the corners/edges
    // TODO improve this drawing
    if ( mPadMode != OneFinger and mPadMode != TwoFingers and mPadMode != ThreeFingers )
    {
        myPainting.setPen( QColor( "Red" ) );
        myPainting.setBrush( QColor( "Red") );
    
        if ( p[mPadMode] & 1 ) myPainting.drawEllipse( x1+o, y1+o, r, r );
        if ( p[mPadMode] & 2 ) myPainting.drawEllipse( x2-o-r, y1+o, r, r );
        if ( p[mPadMode] & 4 ) myPainting.drawEllipse( x2-o-r, y2-o-r, r, r );
        if ( p[mPadMode] & 8 ) myPainting.drawEllipse( x1+o, y2-o-r, r, r );
    }
}

#include "myframe.moc"

