/***************************************************************************
                          satellite.cpp  -  description
                             -------------------
    begin                : Fri Aug 16 2002
    copyright            : (C) 2002 by Luc Langehegermann
    email                : lx2gt@qsl.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "satellite.h"

satellite::satellite(QString name) {
  _name=name;
  _polled=false;
}
// set
void satellite::setPolled(bool polled) {
  _polled=polled;
}
// and get
QString satellite::name() {
  return _name;
}
bool satellite::polled() {
  return _polled;
}
float satellite::longitude() {
  return propagator->getLongitude();
}
float satellite::latitude() {
  return propagator->getLatitude();
}
float satellite::azimuth() {
  return propagator->getAzimuth();
}
float satellite::elevation() {
  return propagator->getElevation();
}
double satellite::nextAosLos() {
  return propagator->getAosLos();
}
float satellite::footprint() {
  return propagator->getFootprint();
}
float satellite::range() {
  return propagator->getRange();
}
float satellite::altitude() {
  return propagator->getHeight();
}
float satellite::velocity() {
  return propagator->getVelocity();
}
long satellite::orbitnum() {
  return propagator->getOrbitNum();
}
float satellite::ma() {
  return propagator->getMA();
}
long long satellite::doppler(unsigned long long f) {
  return propagator->getDoppler(f);
}
QList<transponder>* satellite::translist() {
  return &_translist;
}

float satellite::squint() {
  return propagator->getSquint();
}/** No descriptions */

void satellite::setSquintData(double alon, double alat, int squinttype){
  propagator->alon=alon;
  propagator->alat=alat;
  propagator->squinttype=squinttype;
}

double satellite::ALON() {
  return propagator->alon;
}

double satellite::ALAT() {
  return propagator->alat;
}

int satellite::squinttype() {
  return propagator->squinttype;
}

bool satellite::hasAos() {
  return propagator->hasAos();
}

unsigned int satellite::catnum() {
  return propagator->catnr();
  }

