/***************************************************************************
 *   Copyright (C) 2005 by Raul Fernandes                                  *
 *   rgfbr@yahoo.com.br                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "ktranslator_ocr.h"
#include "qocrprogress.h"
#include "ocrwatchdog.h"
#include "findRec.h"
#include "../../ktranslatordock.h"

#include <kgenericfactory.h>

#include <qtooltip.h>

#include <kapplication.h>
#include <kactionclasses.h>
#include <kpopupmenu.h>
#include <kiconloader.h>
#include <kinputdialog.h>
#include <kapplication.h>
#include <kactionclasses.h>
#include <kpopupmenu.h>
#include <kiconloader.h>

K_EXPORT_COMPONENT_FACTORY( ktranslator_ocr,
                            KGenericFactory<OCR>( "ktranslator_ocr" ) )

OCR::OCR(QObject *parent, const char*, const QStringList& )
            : KTranslator::UIPlugin(parent, "OCR" )
{
    KLocale::setMainCatalogue("ktranslator");
    // Sets the enable/disable OCR plugin
    setInstance(KGenericFactory<OCR>::instance());
    setXMLFile("ktranslator_ocrui.rc");


    // OCR
   watchdog=new OcrWatchdog();
   connect(watchdog,SIGNAL(gotIt(QPixmap,int,int)),this,SLOT(receivePixmap(QPixmap,int,int)));
   ocr=new QOCRProgress(this);
   ocr->setGreyLimit( 254 );
   ocr->setDustSize( 0 );
   connect(ocr,SIGNAL(finishedOCR(QString)),this,SLOT(slotEmitSearch(QString)));
   m_running=false;


    // OCR KAction
    enabled = true;
    ktranslatorDock *dock = (ktranslatorDock*)parent->child("dock");
    actionOCR = new KToggleAction( i18n( "OCR" ), "thumbnail", 0, this, SLOT( toggleOCR() ), actionCollection(), "ocrAction" );
    actionOCR->setWhatsThis( i18n( "Click here to enable the OCR plugin" ) );
    dock->actionCollection()->insert( actionOCR );
    actionOCR->plug( dock->contextMenu(), 1 );
    setEnabled( enabled );
    m_running = false;
}

void OCR::slotEmitSearch( QString text )
{
  //if( !enabled ) return;
  QString word = text;
  emitSearch( word );
}

void OCR::setEnabled( bool enable )
{
    enabled = enable;
    actionOCR->setChecked( enabled );
    if( enabled ) watchdog->activate();
    else watchdog->deactivate();
}

void OCR::toggleOCR()
{
    setEnabled( !enabled );
}

/** Finds an approbiate block of text and delegates OCR to QOcrProgress */
void OCR::receivePixmap(QPixmap pixmap,int xOfPoint,int yOfPoint){
   if (m_running) {
     return;
   }
   m_running=true;
   QImage imageColor=pixmap.convertToImage();
   FindRec findRec(&imageColor);
   findRec.findword(xOfPoint,yOfPoint);
   if (findRec.word_letter==0)
   {
      kdDebug()<<"Found no borders in region."<<endl;
      bool ok;
      QString ocrText=KInputDialog::getText(i18n("No text found"),
               i18n("No text could be found in the region you clicked on.\nDo you want to type it?"),"",&ok);
      if (ok)
         slotEmitSearch(ocrText);

      m_running=false;
      return;
   }
  // kdDebug()<<"Borders: "<<left<<" "<<" "<<up<<" "<<right<<" "<<down<<"\nStarting OCR..."<<endl;
   QImage saveImage = imageColor.copy(findRec.word_x_left,
                                      findRec.word_y_up,
                                      findRec.word_x_right-findRec.word_x_left,
                                      findRec.word_y_down-findRec.word_y_up);
   //its easier for gocr to recognize the word if it is bigger
   QImage scaledImage = saveImage.smoothScale((findRec.word_x_right-findRec.word_x_left+1)*4,
                         (findRec.word_y_down-findRec.word_y_up+1)*4);
   /*scaledImage.save("/tmp/tmp_wordimg.bmp","BMP");
   kdDebug()<<"just saved tmp_wordimg.bmp"<<endl;
   imageColor.save("/tmp/tmp_screenimg.bmp","BMP");*/
   ocr->start(scaledImage);
   m_running=false;
}


void OCR::loadModifierKey()
{
   // calls the function to alter the modifier key that triggers the translation
   watchdog->loadModifierKey();
}
