/***************************************************************************
 *   Copyright (C) 2005-2006 by Raul Fernandes                             *
 *   rgfbr@yahoo.com.br                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef SDICT_H
#define SDICT_H

#include <qmap.h>
#include <qstring.h>

class QFile;
class QCString;

/**
@author Raul Fernandes
*/
class Sdict{
public:
    Sdict( const QString & );

    ~Sdict();

    QString search( const QString & );
    bool isOk(){ return m_isOk; };
    uint size() { return m_size; };
    QString filename() { return m_filename; };
    QString title() { return m_title; };
    QString copyright() { return m_copyright; };
    QString version() { return m_version; };
    QString inlang() { return m_inlang; };
    QString outlang() { return m_outlang; };

//#ifndef NOPTIMIZE
    typedef QMap<QString,ulong> Dictionary;
    Dictionary dic;
//#endif

protected:
    QCString Inflate( const char *, uint );

    QFile *file;
    bool m_isOk;

    uint m_size;
    QString m_filename;
    QString m_title;
    QString m_copyright;
    QString m_version;
    char m_inlang[3];
    char m_outlang[3];
    ushort m_compress;
    ushort m_idxlevels;
    uint m_shortidxlen;
    uint m_shortidx;
    uint m_fullidx;
    uint m_articles;
};

#endif // SDICT_H
